/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.core.rest.group.GroupListResponse;
import com.gentics.mesh.core.rest.group.GroupResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.search.AbstractMultiESTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.test.definition.BasicSearchCrudTestcases;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.codehaus.jettison.json.JSONException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(startServer=true, testSize=TestSize.PROJECT)
public class GroupSearchEndpointTest
extends AbstractMultiESTest
implements BasicSearchCrudTestcases {
    public GroupSearchEndpointTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Override
    @Test
    public void testDocumentCreation() throws InterruptedException, JSONException {
        String groupName = "testgroup42a";
        for (int i = 0; i < 10; ++i) {
            this.createGroup(groupName + i);
        }
        this.waitForSearchIdleEvent();
        GroupListResponse response = (GroupListResponse)ClientHelper.call(() -> this.client().searchGroups(MeshTestHelper.getSimpleTermQuery("name.raw", groupName + "8"), new ParameterProvider[0]));
        Assert.assertEquals((long)1L, (long)response.getData().size());
    }

    @Test
    public void testBogusQuery() {
        String groupName = "testgroup42a";
        String uuid = this.createGroup(groupName).getUuid();
        this.waitForSearchIdleEvent();
        ClientHelper.call(() -> this.client().searchGroups("HudriWudri", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"search_query_not_parsable", (String[])new String[0]);
        GroupListResponse result = (GroupListResponse)ClientHelper.call(() -> this.client().searchGroups(MeshTestHelper.getSimpleTermQuery("uuid", uuid), new ParameterProvider[0]));
        Assertions.assertThat((List)result.getData()).hasSize(1);
        Assert.assertEquals((Object)uuid, (Object)((GroupResponse)result.getData().get(0)).getUuid());
    }

    @Test
    public void testSearchByUuid() throws InterruptedException, JSONException {
        String groupName = "testgroup42a";
        String uuid = this.createGroup(groupName).getUuid();
        this.waitForSearchIdleEvent();
        GroupListResponse result = (GroupListResponse)ClientHelper.call(() -> this.client().searchGroups(MeshTestHelper.getSimpleTermQuery("uuid", uuid), new ParameterProvider[0]));
        Assertions.assertThat((List)result.getData()).hasSize(1);
        Assert.assertEquals((Object)uuid, (Object)((GroupResponse)result.getData().get(0)).getUuid());
    }

    @Test
    public void testSearchByName() throws InterruptedException, JSONException {
        String groupName = "test-grou  %!p42a";
        String uuid = this.createGroup(groupName).getUuid();
        this.waitForSearchIdleEvent();
        GroupListResponse result = (GroupListResponse)ClientHelper.call(() -> this.client().searchGroups(MeshTestHelper.getSimpleTermQuery("name.raw", groupName), new ParameterProvider[0]));
        Assertions.assertThat((List)result.getData()).hasSize(1);
        Assert.assertEquals((Object)uuid, (Object)((GroupResponse)result.getData().get(0)).getUuid());
    }

    @Override
    @Test
    public void testDocumentDeletion() throws InterruptedException, JSONException {
        String groupName = "testgroup42a";
        GroupResponse group = this.createGroup(groupName);
        this.deleteGroup(group.getUuid());
        this.waitForSearchIdleEvent();
        GroupListResponse result = (GroupListResponse)ClientHelper.call(() -> this.client().searchGroups(MeshTestHelper.getSimpleTermQuery("name.raw", groupName), new ParameterProvider[0]));
        Assertions.assertThat((List)result.getData()).hasSize(0);
    }

    @Override
    @Test
    public void testDocumentUpdate() throws InterruptedException, JSONException {
        String groupName = "testgroup42a";
        GroupResponse group = this.createGroup(groupName);
        String newGroupName = "testgrouprenamed";
        this.updateGroup(group.getUuid(), newGroupName);
        this.waitForSearchIdleEvent();
        GroupListResponse result = (GroupListResponse)ClientHelper.call(() -> this.client().searchGroups(MeshTestHelper.getSimpleTermQuery("name.raw", groupName), new ParameterProvider[0]));
        Assertions.assertThat((List)result.getData()).hasSize(0);
        result = (GroupListResponse)ClientHelper.call(() -> this.client().searchGroups(MeshTestHelper.getSimpleTermQuery("name.raw", newGroupName), new ParameterProvider[0]));
        Assertions.assertThat((List)result.getData()).hasSize(1);
    }
}

