/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.Mesh;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.rest.branch.BranchListResponse;
import com.gentics.mesh.core.rest.branch.BranchResponse;
import com.gentics.mesh.core.rest.branch.info.BranchInfoSchemaList;
import com.gentics.mesh.core.rest.branch.info.BranchSchemaInfo;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaResponse;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.StringField;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.core.rest.tag.TagCreateRequest;
import com.gentics.mesh.core.rest.tag.TagFamilyCreateRequest;
import com.gentics.mesh.core.rest.tag.TagFamilyResponse;
import com.gentics.mesh.core.rest.tag.TagResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.search.AbstractMultiESTest;
import com.gentics.mesh.search.verticle.eventhandler.SyncEventHandler;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(startServer=true, testSize=TestSize.PROJECT)
public class LanguageOverrideSearchTest
extends AbstractMultiESTest {
    private List<NodeResponse> createdPages;

    public LanguageOverrideSearchTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Before
    public void setUp() throws Exception {
        this.createdPages = new ArrayList<NodeResponse>();
    }

    @Test
    public void testIndexCountAfterRemovingSettings() {
        int originalIndexCount = this.getIndexCount();
        SchemaResponse schema = this.createSchema(this.loadResourceJsonAsPojo("schemas/languageOverride/page.json", SchemaCreateRequest.class));
        this.waitForSearchIdleEvent();
        Assertions.assertThat((int)this.getIndexCount()).isEqualTo(originalIndexCount + 12);
        this.waitForJob(() -> this.client().updateSchema(schema.getUuid(), this.loadResourceJsonAsPojo("schemas/languageOverride/pageNoEs.json", SchemaUpdateRequest.class), new ParameterProvider[0]).blockingAwait());
        this.waitForSearchIdleEvent();
        Assertions.assertThat((int)this.getIndexCount()).isEqualTo(originalIndexCount + 2);
    }

    @Test
    public void testSchemaMigration() {
        this.grantAdmin();
        int originalIndexCount = this.getIndexCount();
        SchemaResponse schema = this.createSchema(this.loadResourceJsonAsPojo("schemas/languageOverride/page.json", SchemaCreateRequest.class));
        this.createContent();
        this.publishCreatedPages();
        this.waitForSearchIdleEvent();
        this.assertPublishedContentCount(schema.getUuid());
        Assertions.assertThat((int)this.getIndexCount()).isEqualTo(originalIndexCount + 12);
        this.migrateSchema(schema.getName()).blockingAwait();
        this.waitForSearchIdleEvent();
        Assertions.assertThat((int)this.getIndexCount()).isEqualTo(originalIndexCount + 12);
        this.assertPublishedContentCount(schema.getUuid());
    }

    @Test
    public void testIndexCountAfterMigratingOldSchema() {
        this.grantAdmin();
        int originalIndexCount = this.getIndexCount();
        SchemaResponse schema = this.createSchema(this.loadResourceJsonAsPojo("schemas/languageOverride/pageNoEs.json", SchemaCreateRequest.class));
        this.waitForSearchIdleEvent();
        Assertions.assertThat((int)this.getIndexCount()).isEqualTo(originalIndexCount + 2);
        this.waitForJob(() -> this.client().updateSchema(schema.getUuid(), this.loadResourceJsonAsPojo("schemas/languageOverride/page.json", SchemaUpdateRequest.class), new ParameterProvider[0]).blockingAwait());
        this.waitForSearchIdleEvent();
        Assertions.assertThat((int)this.getIndexCount()).isEqualTo(originalIndexCount + 12);
    }

    @Test
    public void testIndexCountAfterDeletingSchema() {
        int originalIndexCount = this.getIndexCount();
        SchemaResponse schema = this.createSchema(this.loadResourceJsonAsPojo("schemas/languageOverride/page.json", SchemaCreateRequest.class));
        this.waitForSearchIdleEvent();
        Assertions.assertThat((int)this.getIndexCount()).isEqualTo(originalIndexCount + 12);
        this.deleteSchema(schema.getUuid());
        this.waitForSearchIdleEvent();
        Assertions.assertThat((int)this.getIndexCount()).isEqualTo(originalIndexCount);
    }

    @Test
    public void testIndexCountAfterProjectDeletion() {
        int originalIndexCount = this.getIndexCount();
        ProjectResponse project = this.createProject();
        this.waitForSearchIdleEvent();
        Assertions.assertThat((int)this.getIndexCount()).isEqualTo(originalIndexCount + 3);
        this.createSchema(project.getName(), this.loadResourceJsonAsPojo("schemas/languageOverride/page.json", SchemaCreateRequest.class));
        this.waitForSearchIdleEvent();
        Assertions.assertThat((int)this.getIndexCount()).isEqualTo(originalIndexCount + 15);
        this.deleteProject(project.getUuid());
        this.waitForSearchIdleEvent();
        Assertions.assertThat((int)this.getIndexCount()).isEqualTo(originalIndexCount);
    }

    @Test
    public void testIndexCountAfterSync() throws Exception {
        int originalIndexCount = this.getIndexCount();
        this.createSchema(this.loadResourceJsonAsPojo("schemas/languageOverride/page.json", SchemaCreateRequest.class));
        this.waitForSearchIdleEvent();
        Assertions.assertThat((int)this.getIndexCount()).isEqualTo(originalIndexCount + 12);
        this.recreateIndices();
        Assertions.assertThat((int)this.getIndexCount()).isEqualTo(originalIndexCount + 12);
    }

    @Test
    public void testLanguageOverride() {
        SchemaResponse schema = this.createSchema(this.loadResourceJsonAsPojo("schemas/languageOverride/page.json", SchemaCreateRequest.class));
        this.createContent();
        this.waitForSearchIdleEvent();
        this.assertContentCount(schema.getUuid());
        this.assertContentSearch("die", "Report");
        this.assertContentSearch("no", "Kino", "Film");
        this.publishCreatedPages();
        this.waitForSearchIdleEvent();
        this.assertPublishedContentCount(schema.getUuid());
    }

    @Test
    public void testIndexSyncWithMicronodeField() throws Exception {
        MicroschemaResponse microschema = this.createMicroschema("micro");
        ClientHelper.call(() -> this.client().assignMicroschemaToProject("dummy", microschema.getUuid()));
        SchemaResponse schema = this.createSchema(this.loadResourceJsonAsPojo("schemas/languageOverride/pageWithMicronode.json", SchemaCreateRequest.class));
        this.createContent();
        this.waitForSearchIdleEvent();
        String microschemaHash = (String)this.tx(tx -> {
            HibSchema schema1 = (HibSchema)tx.schemaDao().findByUuid(schema.getUuid());
            HibSchemaVersion version = (HibSchemaVersion)schema1.getLatestVersion();
            return version.getMicroschemaVersionHash(this.initialBranch());
        });
        this.assertDocumentCount(schema.getUuid(), this.fromEntries(this.docs("de", ContainerType.DRAFT, 2L), this.docs("fr", ContainerType.DRAFT, 1L), this.docs("zh", ContainerType.DRAFT, 1L), this.docs("ja", ContainerType.DRAFT, 1L), this.docs("ko", ContainerType.DRAFT, 1L), this.docs(microschemaHash.toLowerCase(), ContainerType.DRAFT, 3L)));
        SyncEventHandler.invokeSyncCompletable((Mesh)this.meshApi()).blockingAwait(30L, TimeUnit.SECONDS);
        this.assertDocumentCount(schema.getUuid(), this.fromEntries(this.docs("de", ContainerType.DRAFT, 2L), this.docs("fr", ContainerType.DRAFT, 1L), this.docs("zh", ContainerType.DRAFT, 1L), this.docs("ja", ContainerType.DRAFT, 1L), this.docs("ko", ContainerType.DRAFT, 1L), this.docs(microschemaHash.toLowerCase(), ContainerType.DRAFT, 3L)));
        this.assertContentSearch("die", "Report");
        this.assertContentSearch("no", "Kino", "Film");
    }

    @Test
    public void testIndexSync() throws Exception {
        SchemaResponse schema = this.createSchema(this.loadResourceJsonAsPojo("schemas/languageOverride/page.json", SchemaCreateRequest.class));
        this.createContent();
        this.waitForSearchIdleEvent();
        this.assertContentCount(schema.getUuid());
        this.recreateIndices();
        this.assertContentCount(schema.getUuid());
        this.assertContentSearch("die", "Report");
        this.assertContentSearch("no", "Kino", "Film");
    }

    @Test
    public void testIndexAfterMove() throws Exception {
        SchemaResponse schema = this.createSchema(this.loadResourceJsonAsPojo("schemas/languageOverride/page.json", SchemaCreateRequest.class));
        this.createContent();
        this.waitForSearchIdleEvent();
        this.assertContentCount(schema.getUuid());
        NodeResponse folder = this.createFolder("de", "Zielordner");
        NodeResponse page = this.createdPages.get(0);
        this.client().moveNode("dummy", page.getUuid(), folder.getUuid(), new ParameterProvider[0]).blockingAwait();
        this.waitForSearchIdleEvent();
        this.assertContentCount(schema.getUuid());
    }

    @Test
    public void testIndexAfterMoveGeneric() throws Exception {
        SchemaResponse schema = this.createSchema(this.loadResourceJsonAsPojo("schemas/languageOverride/page.json", SchemaCreateRequest.class));
        this.createContent();
        this.waitForSearchIdleEvent();
        this.assertContentCount(schema.getUuid());
        NodeResponse folder = this.createFolder("de", "Zielordner");
        NodeResponse page = this.createdPages.get(1);
        this.client().moveNode("dummy", page.getUuid(), folder.getUuid(), new ParameterProvider[0]).blockingAwait();
        this.waitForSearchIdleEvent();
        this.assertContentCount(schema.getUuid());
    }

    @Test
    public void testIndexAfterTagging() throws Exception {
        SchemaResponse schema = this.createSchema(this.loadResourceJsonAsPojo("schemas/languageOverride/page.json", SchemaCreateRequest.class));
        this.createContent();
        this.waitForSearchIdleEvent();
        this.assertContentCount(schema.getUuid());
        NodeResponse page = this.createdPages.get(0);
        TagFamilyResponse family = (TagFamilyResponse)this.client().createTagFamily("dummy", new TagFamilyCreateRequest().setName("colors")).blockingGet();
        TagResponse tag = (TagResponse)this.client().createTag("dummy", family.getUuid(), new TagCreateRequest().setName("red")).blockingGet();
        this.client().addTagToNode("dummy", page.getUuid(), tag.getUuid(), new ParameterProvider[0]).blockingAwait();
        this.waitForSearchIdleEvent();
        this.assertContentCount(schema.getUuid());
    }

    private void createContent() {
        this.createPage("de", "Wetter", "Es ist herrliches Wetter, denn die Sonne kommt heraus.");
        this.createPage("en", "Report", "Many innocent people die during war.");
        this.createPage("de", "Kino", "Der Film \"Mirai \u2013 Das M\u00e4dchen aus der Zukunft\" (original \"Mirai no Mirai\") wurde zum besten Animationsfilm 2019 nominiert.");
        this.createPage("fr", "Film", "Le film \"Mira\u00ef, ma petite s\u0153ur\" (original \"Mirai no Mirai\") a \u00e9t\u00e9 nomin\u00e9 pour le meilleur film d'animation en 2019.");
        this.createPage("it", "Cinema", "Il film \"Mirai\" (originale \"Mirai no Mirai\") \u00e8 stato nominato come il miglior film d'animazione 2019.");
        this.createPage("en", "Corona", "As of April 2020, there is no vaccine for the Covid-19 virus.");
        this.createPage("zh", "Apology", "There is no chinese content yet.");
        this.createPage("ja", "Apology", "There is no japanese content yet.");
        this.createPage("ko", "Apology", "There is no korean content yet.");
    }

    private void assertContentCount(String schemaUuid) {
        this.assertDocumentCount(schemaUuid, this.fromEntries(this.docs("de", ContainerType.DRAFT, 2L), this.docs("fr", ContainerType.DRAFT, 1L), this.docs("zh", ContainerType.DRAFT, 1L), this.docs("ja", ContainerType.DRAFT, 1L), this.docs("ko", ContainerType.DRAFT, 1L), this.docs("en", ContainerType.DRAFT, 0L), this.docs("it", ContainerType.DRAFT, 0L), this.docs(ContainerType.DRAFT, 3L)));
    }

    private void assertPublishedContentCount(String schemaUuid) {
        this.assertDocumentCount(schemaUuid, this.fromEntries(this.docs("de", ContainerType.DRAFT, 2L), this.docs("fr", ContainerType.DRAFT, 1L), this.docs("zh", ContainerType.DRAFT, 1L), this.docs("ja", ContainerType.DRAFT, 1L), this.docs("ko", ContainerType.DRAFT, 1L), this.docs("en", ContainerType.DRAFT, 0L), this.docs("it", ContainerType.DRAFT, 0L), this.docs(ContainerType.DRAFT, 3L), this.docs("de", ContainerType.PUBLISHED, 2L), this.docs("fr", ContainerType.PUBLISHED, 1L), this.docs("zh", ContainerType.PUBLISHED, 1L), this.docs("ja", ContainerType.PUBLISHED, 1L), this.docs("ko", ContainerType.PUBLISHED, 1L), this.docs("en", ContainerType.PUBLISHED, 0L), this.docs("it", ContainerType.PUBLISHED, 0L), this.docs(ContainerType.PUBLISHED, 3L)));
    }

    private NodeResponse createPage(String language, String title, String content) {
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setParentNode(this.getProject().getRootNode()).setLanguage(language).setSchemaName("page").setFields(FieldMap.of((String)"title", (Field)StringField.of((String)title), (String)"content", (Field)StringField.of((String)content)));
        NodeResponse nodeResponse = (NodeResponse)this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]).blockingGet();
        this.createdPages.add(nodeResponse);
        return nodeResponse;
    }

    private void publishCreatedPages() {
        for (NodeResponse createdPage : this.createdPages) {
            this.publishNode(createdPage);
        }
    }

    private NodeResponse createFolder(String language, String name) {
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setParentNode(this.getProject().getRootNode()).setLanguage(language).setSchemaName("folder").setFields(FieldMap.of((String)"name", (Field)StringField.of((String)name)));
        return (NodeResponse)this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]).blockingGet();
    }

    private void assertContentSearch(String query, String ... titles) {
        NodeListResponse nodeListResponse = this.searchContent(query);
        Assertions.assertThat(nodeListResponse.getData().stream().map(node -> node.getFields().getStringField("title").getString())).containsOnly((Object[])titles);
    }

    private NodeListResponse searchContent(String content) {
        return (NodeListResponse)this.client().searchNodes(new JsonObject().put("query", (Object)new JsonObject().put("match", (Object)new JsonObject().put("fields.content.basicsearch", (Object)content))).toString(), new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"en", "de", "fr", "it", "zh", "ja", "ko"})}).blockingGet();
    }

    private int getIndexCount() {
        try {
            String response = this.httpClient().newCall(new Request.Builder().url(this.getTestContext().getOptions().getSearchOptions().getUrl() + "/_all").build()).execute().body().string();
            return new JsonObject(response).size();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <K, V> Map<K, V> fromEntries(Map.Entry<K, V> ... entries) {
        return Stream.of(entries).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void assertDocumentCount(String schemaUuid, Map<Document, Long> expected) {
        try {
            BranchListResponse branches = (BranchListResponse)this.client().findBranches("dummy", new ParameterProvider[0]).blockingGet();
            BranchResponse branch = branches.getData().stream().filter(BranchResponse::getLatest).findFirst().orElseThrow(() -> new RuntimeException("Did not find latest branch for test project"));
            BranchInfoSchemaList schemaVersions = (BranchInfoSchemaList)this.client().getBranchSchemaVersions("dummy", branch.getUuid()).blockingGet();
            BranchSchemaInfo info = schemaVersions.getSchemas().stream().filter(i -> StringUtils.equals((CharSequence)i.getUuid(), (CharSequence)schemaUuid)).findFirst().orElseThrow(() -> new RuntimeException("Did not find version of schema " + schemaUuid));
            String response = this.httpClient().newCall(new Request.Builder().url(this.getTestContext().getOptions().getSearchOptions().getUrl() + "/mesh-node-*-" + info.getVersionUuid() + "-*/_search").method("POST", RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new JsonObject().put("size", (Object)100).put("query", (Object)new JsonObject().put("query_string", (Object)new JsonObject().put("query", (Object)"*"))).toString())).build()).execute().body().string();
            Map actual = new JsonObject(response).getJsonObject("hits").getJsonArray("hits").stream().map(doc -> (JsonObject)doc).map(Document::fromElasticsearch).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            for (Document key : expected.keySet()) {
                actual.computeIfAbsent(key, k -> 0L);
            }
            Assertions.assertThat(actual).isEqualTo(expected);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map.Entry<Document, Long> docs(ContainerType type, long count) {
        return this.docs(null, type, count);
    }

    private Map.Entry<Document, Long> docs(String language, ContainerType type, long count) {
        return new AbstractMap.SimpleImmutableEntry<Document, Long>(new Document(type, language), count);
    }

    private static class Document {
        private final ContainerType type;
        private final String language;

        private Document(ContainerType type, String language) {
            this.language = language;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Document that = (Document)o;
            return Objects.equals(this.language, that.language) && this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(this.language, this.type);
        }

        public String toString() {
            return this.type.getShortName() + (String)(this.language == null ? "" : "-" + this.language);
        }

        public static Document fromElasticsearch(JsonObject doc) {
            String[] split = doc.getString("_index").split("-");
            return new Document(ContainerType.forVersion((String)split[5]), split.length > 6 ? split[6] : null);
        }
    }
}

