/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaCreateRequest;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaResponse;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.MicronodeField;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaModel;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.search.index.node.NodeContainerMappingProvider;
import com.gentics.mesh.core.search.index.node.NodeIndexHandler;
import com.gentics.mesh.etc.config.search.ComplianceMode;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.Tuple;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class MicroschemaMappingTest
extends AbstractMeshTest {
    private static final String SCHEMA_NAME = "test_schema";
    private static final String MICROSCHEMA_NAME = "test_microschema";
    private static final String MICRONODE_FIELD_NAME = "micronodeField";
    private static final String MICRONODE_LIST_FIELD_NAME = "micronodeListField";
    private static final String DYNAMIC_FIELD_NAME = "testField";
    @Parameterized.Parameter(value=0)
    public FieldSchema schemaField;
    @Parameterized.Parameter(value=1)
    public JsonObject fieldMapping;
    @Parameterized.Parameter(value=2)
    public Field nodeField;
    @Parameterized.Parameter(value=3)
    public Function<String, JsonObject> searchQuery;
    private SchemaResponse schema;

    @Parameterized.Parameters
    public static Collection<Object[]> paramData() {
        return Arrays.asList({FieldUtil.createStringFieldSchema((String)DYNAMIC_FIELD_NAME), new JsonObject().put("test", (Object)new JsonObject().put("type", (Object)"keyword").put("index", (Object)true)), FieldUtil.createStringField((String)"aaa-aaa"), path -> new JsonObject().put("term", (Object)new JsonObject().put(path + ".test", (Object)"aaa-aaa"))}, {FieldUtil.createStringFieldSchema((String)DYNAMIC_FIELD_NAME), new JsonObject().put("test", (Object)new JsonObject().put("type", (Object)"text").put("index", (Object)true)), FieldUtil.createStringField((String)"a very cool test string"), path -> new JsonObject().put("match", (Object)new JsonObject().put(path + ".test", (Object)"cool"))}, {FieldUtil.createHtmlFieldSchema((String)DYNAMIC_FIELD_NAME), new JsonObject().put("test", (Object)new JsonObject().put("type", (Object)"keyword").put("index", (Object)true)), FieldUtil.createHtmlField((String)"aaa-aaa"), path -> new JsonObject().put("term", (Object)new JsonObject().put(path + ".test", (Object)"aaa-aaa"))}, {FieldUtil.createHtmlFieldSchema((String)DYNAMIC_FIELD_NAME), new JsonObject().put("test", (Object)new JsonObject().put("type", (Object)"text").put("index", (Object)true)), FieldUtil.createHtmlField((String)"a very cool test string"), path -> new JsonObject().put("match", (Object)new JsonObject().put(path + ".test", (Object)"cool"))}, {FieldUtil.createListFieldSchema((String)DYNAMIC_FIELD_NAME, (String)"string"), new JsonObject().put("test", (Object)new JsonObject().put("type", (Object)"keyword").put("index", (Object)true)), FieldUtil.createStringListField((String[])new String[]{"aaa-aaa"}), path -> new JsonObject().put("term", (Object)new JsonObject().put(path + ".test", (Object)"aaa-aaa"))}, {FieldUtil.createListFieldSchema((String)DYNAMIC_FIELD_NAME, (String)"string"), new JsonObject().put("test", (Object)new JsonObject().put("type", (Object)"text").put("index", (Object)true)), FieldUtil.createStringListField((String[])new String[]{"a very cool test string"}), path -> new JsonObject().put("match", (Object)new JsonObject().put(path + ".test", (Object)"cool"))}, {FieldUtil.createListFieldSchema((String)DYNAMIC_FIELD_NAME, (String)"html"), new JsonObject().put("test", (Object)new JsonObject().put("type", (Object)"keyword").put("index", (Object)true)), FieldUtil.createHtmlListField((String[])new String[]{"aaa-aaa"}), path -> new JsonObject().put("term", (Object)new JsonObject().put(path + ".test", (Object)"aaa-aaa"))}, {FieldUtil.createListFieldSchema((String)DYNAMIC_FIELD_NAME, (String)"html"), new JsonObject().put("test", (Object)new JsonObject().put("type", (Object)"text").put("index", (Object)true)), FieldUtil.createHtmlListField((String[])new String[]{"a very cool test string"}), path -> new JsonObject().put("match", (Object)new JsonObject().put(path + ".test", (Object)"cool"))});
    }

    @Before
    public void createDummySchemas() {
        MicroschemaCreateRequest createMicroschema = new MicroschemaCreateRequest();
        createMicroschema.setName(MICROSCHEMA_NAME);
        createMicroschema.addField(this.schemaField.setElasticsearch(this.fieldMapping));
        MicroschemaResponse microschema = (MicroschemaResponse)ClientHelper.call(() -> this.client().createMicroschema(createMicroschema));
        ClientHelper.call(() -> this.client().assignMicroschemaToProject("dummy", microschema.getUuid()));
        SchemaCreateRequest createSchema = new SchemaCreateRequest();
        createSchema.setName(SCHEMA_NAME);
        createSchema.addField((FieldSchema)FieldUtil.createMicronodeFieldSchema((String)MICRONODE_FIELD_NAME).setAllowedMicroSchemas(new String[]{MICROSCHEMA_NAME}));
        createSchema.addField((FieldSchema)FieldUtil.createListFieldSchema((String)MICRONODE_LIST_FIELD_NAME, (String)"micronode").setAllowedSchemas(new String[]{MICROSCHEMA_NAME}));
        this.schema = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(createSchema, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", this.schema.getUuid()));
        this.waitForSearchIdleEvent();
    }

    @Test
    public void testMicroschemaCustomMappingJson() {
        NodeIndexHandler handler = this.mesh().indexHandlerRegistry().getNodeIndexHandler();
        NodeContainerMappingProvider provider = handler.getMappingProvider();
        ComplianceMode mode = this.options().getSearchOptions().getComplianceMode();
        this.tx(() -> {
            HibBranch branch = this.latestBranch();
            JsonObject schemaMapping = provider.getMapping((SchemaModel)this.schema, branch, null);
            if (mode == ComplianceMode.ES_6) {
                schemaMapping = schemaMapping.getJsonObject("default");
            }
            Assert.assertNotNull((Object)schemaMapping);
            JsonObject fieldsMapping = schemaMapping.getJsonObject("properties").getJsonObject("fields");
            Assert.assertNotNull((Object)fieldsMapping);
            JsonObject microschemaMapping = fieldsMapping.getJsonObject("properties").getJsonObject(MICRONODE_FIELD_NAME).getJsonObject("properties").getJsonObject("fields-test_microschema");
            Assert.assertNotNull((Object)microschemaMapping);
            JsonObject fieldMapping = microschemaMapping.getJsonObject("properties").getJsonObject(DYNAMIC_FIELD_NAME);
            Assert.assertEquals((Object)this.fieldMapping, (Object)fieldMapping.getJsonObject("fields"));
        });
    }

    @Test
    public void testMicroschemaCustomMappingSearch() {
        String searchPath = "fields.micronodeField.fields-test_microschema.testField";
        this.tx(() -> {
            NodeCreateRequest createNode = new NodeCreateRequest();
            createNode.setSchemaName(SCHEMA_NAME);
            createNode.setLanguage("en");
            createNode.setParentNodeUuid(this.project().getBaseNode().getUuid());
            createNode.getFields().put(MICRONODE_FIELD_NAME, (Field)FieldUtil.createMicronodeField((String)MICROSCHEMA_NAME, (Tuple[])new Tuple[]{new Tuple((Object)DYNAMIC_FIELD_NAME, (Object)this.nodeField)}));
            NodeResponse node = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", createNode, new ParameterProvider[0]));
            this.waitForSearchIdleEvent();
            NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes(this.project().getName(), new JsonObject().put("query", (Object)this.searchQuery.apply(searchPath)).encode(), new ParameterProvider[0]));
            Assert.assertEquals((long)response.getMetainfo().getTotalCount(), (long)1L);
            NodeResponse responseNode = (NodeResponse)response.getData().get(0);
            Assert.assertEquals((Object)SCHEMA_NAME, (Object)responseNode.getSchema().getName());
            Assert.assertEquals((Object)node.getUuid(), (Object)responseNode.getUuid());
        });
    }

    @Test
    public void testNestedMicroschemaCustomMappingSearch() {
        String searchPath = "fields.micronodeListField.fields-test_microschema.testField";
        this.tx(() -> {
            NodeCreateRequest createNode = new NodeCreateRequest();
            createNode.setSchemaName(SCHEMA_NAME);
            createNode.setLanguage("en");
            createNode.setParentNodeUuid(this.project().getBaseNode().getUuid());
            createNode.getFields().put(MICRONODE_LIST_FIELD_NAME, FieldUtil.createMicronodeListField((MicronodeField[])new MicronodeField[]{FieldUtil.createMicronodeField((String)MICROSCHEMA_NAME, (Tuple[])new Tuple[]{new Tuple((Object)DYNAMIC_FIELD_NAME, (Object)this.nodeField)})}));
            NodeResponse node = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", createNode, new ParameterProvider[0]));
            JsonObject query = new JsonObject().put("query", (Object)new JsonObject().put("nested", (Object)new JsonObject().put("path", (Object)"fields.micronodeListField").put("query", (Object)this.searchQuery.apply(searchPath))));
            this.waitForSearchIdleEvent();
            NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes(this.project().getName(), query.encode(), new ParameterProvider[0]));
            Assert.assertEquals((long)response.getMetainfo().getTotalCount(), (long)1L);
            NodeResponse responseNode = (NodeResponse)response.getData().get(0);
            Assert.assertEquals((Object)SCHEMA_NAME, (Object)responseNode.getSchema().getName());
            Assert.assertEquals((Object)node.getUuid(), (Object)responseNode.getUuid());
        });
    }
}

