/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.core.rest.common.ListResponse;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.core.rest.user.NodeReference;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.search.AbstractNodeSearchEndpointTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.category.FailingTests;
import com.gentics.mesh.test.context.MeshTestHelper;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import java.util.concurrent.atomic.AtomicReference;
import org.codehaus.jettison.json.JSONException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class MultipleActionsTest
extends AbstractNodeSearchEndpointTest {
    public static final String SCHEMA_NAME = "content";

    public MultipleActionsTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Test
    @Category(value={FailingTests.class})
    public void testActions() throws Exception {
        this.recreateIndices();
        boolean nodeCount = true;
        this.getNodesBySchema(SCHEMA_NAME).flatMapCompletable(this::deleteNode).andThen((CompletableSource)this.deleteSchemaByName(SCHEMA_NAME)).andThen(this.createTestSchema()).flatMapObservable(newSchema -> this.getRootNodeReference().flatMapObservable(rootNodeReference -> Observable.range((int)1, (int)1).flatMapSingle(unused -> this.createEmptyNode((SchemaResponse)newSchema, (NodeReference)rootNodeReference)))).ignoreElements().blockingAwait();
        this.waitForSearchIdleEvent();
        NodeListResponse searchResult = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes(MeshTestHelper.getSimpleTermQuery("schema.name.raw", SCHEMA_NAME), new ParameterProvider[0]));
        Assert.assertEquals((String)"Check search result after actions", (long)1L, (long)searchResult.getMetainfo().getTotalCount());
    }

    private Observable<NodeResponse> getNodesBySchema(String schemaName) throws JSONException {
        return this.client().findNodes("dummy", new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"en", "de"})}).toObservable().flatMapIterable(ListResponse::getData).filter(nr -> nr.getSchema().getName().equals(schemaName));
    }

    private Completable deleteNode(NodeResponse node) {
        return this.client().deleteNode("dummy", node.getUuid(), new ParameterProvider[0]).toCompletable();
    }

    private Completable deleteSchemaByName(String schemaName) throws JSONException {
        SchemaResponse schema = this.getSchemaByName(schemaName);
        return this.client().deleteSchema(schema.getUuid()).toCompletable();
    }

    private Single<SchemaResponse> createTestSchema() {
        AtomicReference schemaResponse = new AtomicReference();
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setName(SCHEMA_NAME);
        request.addField((FieldSchema)new StringFieldSchemaImpl().setName("testfield1"));
        request.addField((FieldSchema)new StringFieldSchemaImpl().setName("testfield2"));
        return this.client().createSchema(request, new ParameterProvider[0]).toSingle().doOnSuccess(schemaResponse::set).flatMapCompletable(it -> this.client().assignSchemaToProject("dummy", it.getUuid()).toCompletable()).andThen((SingleSource)Single.defer(() -> Single.just((Object)((SchemaResponse)schemaResponse.get()))));
    }

    private Single<NodeResponse> createEmptyNode(SchemaResponse schema, NodeReference parentNode) {
        NodeCreateRequest request = new NodeCreateRequest();
        request.setSchema((SchemaReference)schema.toReference());
        request.setLanguage("en");
        request.setParentNode(parentNode);
        return this.client().createNode("dummy", request, new ParameterProvider[0]).toSingle();
    }

    private Single<NodeReference> getRootNodeReference() {
        return this.client().findProjectByName("dummy", new ParameterProvider[0]).toSingle().map(it -> it.getRootNode());
    }
}

