/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.impl.BinaryFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.search.AbstractNodeSearchEndpointTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshCoreOptionChanger;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.util.IndexOptionHelper;
import io.vertx.core.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true, optionChanger=MeshCoreOptionChanger.EXCLUDE_BINARY_SEARCH)
public class NodeBinaryDisabledSearchTest
extends AbstractNodeSearchEndpointTest {
    public NodeBinaryDisabledSearchTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Test
    public void testBinarySearchMapping() throws Exception {
        this.grantAdmin();
        String nodeUuid = (String)this.tx(() -> this.content("concorde").getUuid());
        String contentSchemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        SchemaUpdateRequest schemaUpdateRequest = ((SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(contentSchemaUuid, new ParameterProvider[0]))).toUpdateRequest();
        List<String> names = Arrays.asList("binary", "binary2", "binary3");
        for (String name : names) {
            BinaryFieldSchemaImpl binaryField = new BinaryFieldSchemaImpl();
            binaryField.setName(name);
            JsonObject customMapping = new JsonObject();
            customMapping.put("mimeType", (Object)IndexOptionHelper.getRawFieldOption());
            customMapping.put("file.content", (Object)IndexOptionHelper.getRawFieldOption());
            binaryField.setElasticsearch(customMapping);
            schemaUpdateRequest.addField((FieldSchema)binaryField);
        }
        this.waitForJob(() -> ClientHelper.call(() -> this.client().updateSchema(contentSchemaUuid, schemaUpdateRequest, new ParameterProvider[0])));
        byte[] bytes = Base64.getDecoder().decode("e1xydGYxXGFuc2kNCkxvcmVtIGlwc3VtIGRvbG9yIHNpdCBhbWV0DQpccGFyIH0=");
        ClientHelper.call(() -> this.client().updateNodeBinaryField(this.projectName(), nodeUuid, "en", "draft", "binary", (InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, "test.rtf", "application/rtf", new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().updateNodeBinaryField(this.projectName(), nodeUuid, "en", "draft", "binary2", (InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, "test.rtf", "application/rtf", new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        try (Tx tx = this.tx();){
            HibNode nodeA = this.content("concorde");
            String schemaVersionUuid = ((HibSchemaVersion)nodeA.getSchemaContainer().getLatestVersion()).getUuid();
            String indexName = ContentDao.composeIndexName((String)this.projectUuid(), (String)this.initialBranchUuid(), (String)schemaVersionUuid, (ContainerType)ContainerType.DRAFT, null, (String)((HibSchemaVersion)nodeA.getSchemaContainer().getLatestVersion()).getMicroschemaVersionHash(this.initialBranch()));
            String id = ContentDao.composeDocumentId((String)nodeA.getUuid(), (String)"en");
            JsonObject doc = (JsonObject)this.getProvider().getDocument(indexName, id).blockingGet();
            Assert.assertFalse((String)"The information should not have been added to the search document.", (boolean)doc.getJsonObject("_source").getJsonObject("fields").getJsonObject("binary").containsKey("file"));
            tx.success();
        }
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.binary.file.content", "Lorem ipsum dolor sit amet"), new ParameterProvider[0]));
        Assert.assertEquals((String)"No node should be found.", (long)0L, (long)response.getData().size());
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleTermQuery("fields.binary.file.content.raw", "Lorem ipsum dolor sit amet"), new ParameterProvider[0]));
        Assert.assertEquals((String)"No node should be found.", (long)0L, (long)response.getData().size());
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleTermQuery("fields.binary.mimeType", "application/rtf"), new ParameterProvider[0]));
        Assert.assertEquals((String)"Exactly one node should be found for the given image mime type.", (long)1L, (long)response.getData().size());
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleTermQuery("fields.binary.mimeType.raw", "application/rtf"), new ParameterProvider[0]));
        Assert.assertEquals((String)"Exactly one node should be found for the given image mime type.", (long)1L, (long)response.getData().size());
    }

    @Test
    public void testDocumentSearch() throws Exception {
        String nodeUuid = (String)this.tx(() -> this.content("concorde").getUuid());
        String contentSchemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        SchemaUpdateRequest schemaUpdateRequest = ((SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(contentSchemaUuid, new ParameterProvider[0]))).toUpdateRequest();
        schemaUpdateRequest.addField((FieldSchema)new BinaryFieldSchemaImpl().setName("binary"));
        this.waitForJob(() -> ClientHelper.call(() -> this.client().updateSchema(contentSchemaUuid, schemaUpdateRequest, new ParameterProvider[0])));
        byte[] bytes = Base64.getDecoder().decode("e1xydGYxXGFuc2kNCkxvcmVtIGlwc3VtIGRvbG9yIHNpdCBhbWV0DQpccGFyIH0=");
        ClientHelper.call(() -> this.client().updateNodeBinaryField(this.projectName(), nodeUuid, "en", "draft", "binary", (InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, "test.rtf", "application/rtf", new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        try (Tx tx = this.tx();){
            HibNode nodeA = this.content("concorde");
            String indexName = ContentDao.composeIndexName((String)this.projectUuid(), (String)this.initialBranchUuid(), (String)((HibSchemaVersion)nodeA.getSchemaContainer().getLatestVersion()).getUuid(), (ContainerType)ContainerType.DRAFT, null, null);
            String id = ContentDao.composeDocumentId((String)nodeUuid, (String)"en");
            JsonObject doc = (JsonObject)this.getProvider().getDocument(indexName, id).blockingGet();
            Assert.assertFalse((String)"The binary content should not be part of the document", (boolean)doc.getJsonObject("_source").getJsonObject("fields").getJsonObject("binary").containsKey("file"));
            tx.success();
        }
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getRangeQuery("fields.binary.filesize", 40.0, 50.0), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Exactly one node should be found for the given filesize range.", (long)1L, (long)response.getData().size());
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleTermQuery("fields.binary.mimeType", "application/rtf"), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Exactly one node should be found for the given image mime type.", (long)1L, (long)response.getData().size());
    }

    @Test
    public void testImageSearch() throws IOException {
        this.grantAdmin();
        HibNode nodeA = this.content("concorde");
        String nodeUuid = (String)this.tx(() -> nodeA.getUuid());
        String contentSchemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        SchemaUpdateRequest schemaUpdateRequest = ((SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(contentSchemaUuid, new ParameterProvider[0]))).toUpdateRequest();
        schemaUpdateRequest.addField((FieldSchema)new BinaryFieldSchemaImpl().setName("binary"));
        this.waitForJob(() -> ClientHelper.call(() -> this.client().updateSchema(contentSchemaUuid, schemaUpdateRequest, new ParameterProvider[0])));
        byte[] bytes = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("/pictures/blume.jpg"));
        ClientHelper.call(() -> this.client().updateNodeBinaryField(this.projectName(), nodeUuid, "en", "draft", "binary", (InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, "blume.jpg", "image/jpeg", new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getRangeQuery("fields.binary.width", 1150.0, 1170.0), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Exactly one node should be found for the given image width range.", (long)1L, (long)response.getData().size());
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getRangeQuery("fields.binary.height", 1276.0, 1476.0), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Exactly one node should be found for the given image height range.", (long)1L, (long)response.getData().size());
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleTermQuery("fields.binary.dominantColor", "#737042"), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Exactly one node should be found for the given image dominant color.", (long)1L, (long)response.getData().size());
    }
}

