/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.schema.SchemaListResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.search.AbstractMultiESTest;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeBinaryDocumentMigrationTest
extends AbstractMultiESTest {
    public NodeBinaryDocumentMigrationTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Test
    public void schemaMigrationWithDocumentBinary() {
        this.grantAdmin();
        this.uploadDocumentNode();
        this.waitForJobs(this::migrateSchema, JobStatus.COMPLETED, 1);
    }

    private void uploadDocumentNode() {
        NodeResponse node = (NodeResponse)this.createBinaryContent().blockingGet();
        Buffer buffer = Buffer.buffer((String)"This is a text");
        this.client().updateNodeBinaryField("dummy", node.getUuid(), node.getLanguage(), node.getVersion(), "binary", (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "text.txt", "text/plain", new ParameterProvider[0]).blockingAwait();
    }

    private void migrateSchema() {
        SchemaListResponse schemas = (SchemaListResponse)this.client().findSchemas(new ParameterProvider[0]).toSingle().blockingGet();
        SchemaResponse schema = schemas.getData().stream().filter(s -> s.getName().equals("binary_content")).findFirst().get();
        SchemaUpdateRequest request = schema.toUpdateRequest();
        request.getFields().add(new StringFieldSchemaImpl().setName("some_field"));
        this.client().updateSchema(schema.getUuid(), request, new ParameterProvider[0]).blockingAwait();
    }
}

