/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.binary.HibBinary;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibBinaryField;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.BinaryFieldSchemaImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.search.AbstractNodeSearchEndpointTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.util.IndexOptionHelper;
import io.reactivex.Flowable;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeBinaryDocumentSearchTest
extends AbstractNodeSearchEndpointTest {
    public NodeBinaryDocumentSearchTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Test
    public void testBinarySearchMapping() throws Exception {
        HibNode nodeB;
        try (Tx tx = this.tx();){
            HibNode nodeA = this.content("concorde");
            nodeB = this.content();
            ContentDao contentDao = tx.contentDao();
            SchemaVersionModel schema = ((HibSchemaVersion)nodeA.getSchemaContainer().getLatestVersion()).getSchema();
            List<String> names = Arrays.asList("binary", "binary2", "binary3");
            for (String name : names) {
                BinaryFieldSchemaImpl binaryField = new BinaryFieldSchemaImpl();
                binaryField.setName(name);
                JsonObject customMapping = new JsonObject();
                customMapping.put("mimeType", (Object)IndexOptionHelper.getRawFieldOption());
                customMapping.put("file.content", (Object)IndexOptionHelper.getRawFieldOption());
                binaryField.setElasticsearch(customMapping);
                schema.addField((FieldSchema)binaryField);
            }
            ((HibSchemaVersion)nodeA.getSchemaContainer().getLatestVersion()).setSchema(schema);
            this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)((HibSchemaVersion)nodeA.getSchemaContainer().getLatestVersion()));
            HibBinary binaryA = (HibBinary)tx.binaries().create("someHashA", 200L).runInExistingTx(tx);
            binaryA.setImageHeight(Integer.valueOf(200));
            binaryA.setImageWidth(Integer.valueOf(400));
            HibNodeFieldContainer originalA = contentDao.getLatestDraftFieldContainer(nodeA, this.english());
            HibNodeFieldContainer newFieldContainerA = contentDao.createFieldContainer(nodeA, this.english(), this.project().getLatestBranch(), this.user(), originalA, true);
            newFieldContainerA.createBinary("binary", binaryA).setImageDominantColor("#super").setFileName("somefile.jpg").setMimeType("image/jpeg");
            HibBinary binaryB = (HibBinary)tx.binaries().create("someHashB", 200L).runInExistingTx(tx);
            byte[] bytes = Base64.getDecoder().decode("e1xydGYxXGFuc2kNCkxvcmVtIGlwc3VtIGRvbG9yIHNpdCBhbWV0DQpccGFyIH0=");
            this.mesh().binaryStorage().store(Flowable.fromArray((Object[])new Buffer[]{Buffer.buffer((byte[])bytes)}), binaryB.getUuid()).blockingAwait();
            HibNodeFieldContainer originalB = contentDao.getLatestDraftFieldContainer(nodeB, this.english());
            HibNodeFieldContainer newFieldContainerB = contentDao.createFieldContainer(nodeB, this.english(), this.project().getLatestBranch(), this.user(), originalB, true);
            newFieldContainerB.createBinary("binary", binaryB).setFileName("somefile.dat").setMimeType("text/plain");
            newFieldContainerB.createBinary("binary2", binaryB).setFileName("somefile.dat").setMimeType("text/plain");
            tx.success();
        }
        this.recreateIndices();
        tx = this.tx();
        try {
            String indexName = ContentDao.composeIndexName((String)this.projectUuid(), (String)this.initialBranchUuid(), (String)((HibSchemaVersion)nodeB.getSchemaContainer().getLatestVersion()).getUuid(), (ContainerType)ContainerType.DRAFT, null, null);
            String id = ContentDao.composeDocumentId((String)nodeB.getUuid(), (String)"en");
            JsonObject doc = (JsonObject)this.getProvider().getDocument(indexName, id).blockingGet();
            Assert.assertFalse((boolean)doc.getJsonObject("_source").getJsonObject("fields").getJsonObject("binary").containsKey("file"));
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.binary.file.content", "Lorem ipsum dolor sit amet"), new ParameterProvider[0]));
        Assert.assertEquals((String)"No content should be found for the given content since the field was not added to the index.", (long)0L, (long)response.getData().size());
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleTermQuery("fields.binary.file.content.raw", "Lorem ipsum dolor sit amet"), new ParameterProvider[0]));
        Assert.assertEquals((String)"Exactly one node should be found for the given content.", (long)0L, (long)response.getData().size());
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleTermQuery("fields.binary.mimeType", "text/plain"), new ParameterProvider[0]));
        Assert.assertEquals((String)"Exactly one node should be found for the given image mime type.", (long)1L, (long)response.getData().size());
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleTermQuery("fields.binary.mimeType.raw", "text/plain"), new ParameterProvider[0]));
        Assert.assertEquals((String)"Exactly one node should be found for the given image mime type.", (long)1L, (long)response.getData().size());
    }

    @Test
    public void testSearchBinaryField() throws Exception {
        HibNode nodeB;
        try (Tx tx = this.tx();){
            HibNode nodeA = this.content("concorde");
            nodeB = this.content();
            ContentDao contentDao = tx.contentDao();
            SchemaVersionModel schema = ((HibSchemaVersion)nodeA.getSchemaContainer().getLatestVersion()).getSchema();
            schema.addField((FieldSchema)new BinaryFieldSchemaImpl().setName("binary"));
            ((HibSchemaVersion)nodeA.getSchemaContainer().getLatestVersion()).setSchema(schema);
            this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)((HibSchemaVersion)nodeA.getSchemaContainer().getLatestVersion()));
            HibBinary binaryA = (HibBinary)tx.binaries().create("someHashA", 200L).runInExistingTx(tx);
            binaryA.setImageHeight(Integer.valueOf(200));
            binaryA.setImageWidth(Integer.valueOf(400));
            HibNodeFieldContainer originalA = contentDao.getLatestDraftFieldContainer(nodeA, this.english());
            HibNodeFieldContainer newFieldContainerA = contentDao.createFieldContainer(nodeA, this.english(), this.project().getLatestBranch(), this.user(), originalA, true);
            newFieldContainerA.createBinary("binary", binaryA).setImageDominantColor("#super").setFileName("somefile.jpg").setMimeType("image/jpeg");
            HibBinary binaryB = (HibBinary)tx.binaries().create("someHashB", 200L).runInExistingTx(tx);
            HibNodeFieldContainer originalB = contentDao.getLatestDraftFieldContainer(nodeB, this.english());
            HibNodeFieldContainer newFieldContainerB = contentDao.createFieldContainer(nodeB, this.english(), this.project().getLatestBranch(), this.user(), originalB, true);
            HibBinaryField binary = newFieldContainerB.createBinary("binary", binaryB);
            binary.setMimeType("text/plain").setFileName("somefile.dat");
            byte[] bytes = Base64.getDecoder().decode("e1xydGYxXGFuc2kNCkxvcmVtIGlwc3VtIGRvbG9yIHNpdCBhbWV0DQpccGFyIH0=");
            this.mesh().binaryStorage().store(Flowable.fromArray((Object[])new Buffer[]{Buffer.buffer((byte[])bytes)}), binary.getBinary().getUuid()).blockingAwait();
            tx.success();
        }
        this.recreateIndices();
        tx = this.tx();
        try {
            String indexName = ContentDao.composeIndexName((String)this.projectUuid(), (String)this.initialBranchUuid(), (String)((HibSchemaVersion)nodeB.getSchemaContainer().getLatestVersion()).getUuid(), (ContainerType)ContainerType.DRAFT, null, null);
            String id = ContentDao.composeDocumentId((String)nodeB.getUuid(), (String)"en");
            JsonObject doc = (JsonObject)this.getProvider().getDocument(indexName, id).blockingGet();
            Assert.assertFalse((boolean)doc.getJsonObject("_source").getJsonObject("fields").getJsonObject("binary").containsKey("file"));
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getRangeQuery("fields.binary.filesize", 100.0, 300.0), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Exactly two nodes should be found for the given filesize range.", (long)2L, (long)response.getData().size());
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getRangeQuery("fields.binary.width", 300.0, 500.0), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Exactly one node should be found for the given image width range.", (long)1L, (long)response.getData().size());
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getRangeQuery("fields.binary.height", 100.0, 300.0), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Exactly one node should be found for the given image height range.", (long)1L, (long)response.getData().size());
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleTermQuery("fields.binary.dominantColor", "#super"), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Exactly one node should be found for the given image dominant color.", (long)1L, (long)response.getData().size());
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleTermQuery("fields.binary.mimeType", "image/jpeg"), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Exactly one node should be found for the given image mime type.", (long)1L, (long)response.getData().size());
    }
}

