/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.rest.branch.BranchCreateRequest;
import com.gentics.mesh.core.rest.branch.BranchReference;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.SchemaListResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.SchemaUpdateParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.search.AbstractNodeSearchEndpointTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.MeshTestHelper;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeSearchEndpointATest
extends AbstractNodeSearchEndpointTest {
    public NodeSearchEndpointATest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Test
    public void testSearchPublishedNodes() throws Exception {
        this.recreateIndices();
        String oldContent = "supersonic";
        String newContent = "urschnell";
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", newContent), new ParameterProvider[0]));
        Assertions.assertThat((List)response.getData()).as("Published search result", new Object[0]).isEmpty();
        String uuid = (String)this.db().tx(() -> this.content("concorde").getUuid());
        NodeResponse concorde = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        ClientHelper.call(() -> this.client().publishNode("dummy", uuid, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", oldContent), new ParameterProvider[]{new VersioningParametersImpl().published()}));
        ((AbstractListAssert)Assertions.assertThat((List)response.getData()).as("Published search result", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new NodeResponse[]{concorde});
        NodeUpdateRequest update = new NodeUpdateRequest();
        update.setLanguage("en");
        update.getFields().put("content", (Field)FieldUtil.createHtmlField((String)newContent));
        update.setVersion("1.0");
        ClientHelper.call(() -> this.client().updateNode("dummy", concorde.getUuid(), update, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", oldContent), new ParameterProvider[]{new VersioningParametersImpl().published()}));
        ((AbstractListAssert)Assertions.assertThat((List)response.getData()).as("Published search result", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new NodeResponse[]{concorde});
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", newContent), new ParameterProvider[]{new VersioningParametersImpl().published()}));
        Assertions.assertThat((List)response.getData()).as("Published search result", new Object[0]).isEmpty();
        ClientHelper.call(() -> this.client().publishNode("dummy", (String)this.db().tx(() -> this.content("concorde").getUuid()), new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", oldContent), new ParameterProvider[0]));
        Assertions.assertThat((List)response.getData()).as("Published search result", new Object[0]).isEmpty();
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", newContent), new ParameterProvider[0]));
        ((AbstractListAssert)Assertions.assertThat((List)response.getData()).as("Published search result", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new NodeResponse[]{concorde});
    }

    @Test
    public void testSearchWithBranchUuid() throws Exception {
        this.recreateIndices();
        this.grantAdmin();
        String query = MeshTestHelper.getSimpleTermQuery("branchUuid", this.initialBranchUuid());
        long initialCount = ((NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", query, new ParameterProvider[0]))).getMetainfo().getTotalCount();
        this.waitForLatestJob(() -> {
            BranchCreateRequest branchCreateRequest = new BranchCreateRequest();
            branchCreateRequest.setName("extraBranch");
            branchCreateRequest.setLatest(false);
            branchCreateRequest.setBaseBranch((BranchReference)new BranchReference().setUuid(this.initialBranchUuid()));
            ClientHelper.call(() -> this.client().createBranch("dummy", branchCreateRequest, new ParameterProvider[0]));
        });
        long afterCount = ((NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", query, new ParameterProvider[0]))).getMetainfo().getTotalCount();
        Assert.assertEquals((String)"The amount of hits should not change after creating a new branch", (long)afterCount, (long)initialCount);
    }

    @Test
    public void testSearchAfterSchemaUpdate() throws Exception {
        this.recreateIndices();
        String query = MeshTestHelper.getSimpleTermQuery("schema.name.raw", "content");
        long oldCount = ((NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", query, new ParameterProvider[0]))).getMetainfo().getTotalCount();
        SchemaResponse schema = ((SchemaListResponse)ClientHelper.call(() -> this.client().findSchemas("dummy", new ParameterProvider[0]))).getData().stream().filter(it -> it.getName().equals("content")).findAny().get();
        List fields = schema.getFields();
        fields.add(new StringFieldSchemaImpl().setName("test").setLabel("Test"));
        this.grantAdmin();
        this.waitForJobs(() -> {
            SchemaUpdateRequest updateRequest = new SchemaUpdateRequest().setFields(fields).setName(schema.getName());
            ClientHelper.call(() -> this.client().updateSchema(schema.getUuid(), updateRequest, new ParameterProvider[]{new SchemaUpdateParametersImpl().setUpdateAssignedBranches(true)}));
        }, JobStatus.COMPLETED, 1);
        this.waitForSearchIdleEvent();
        long newCount = ((NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", query, new ParameterProvider[0]))).getMetainfo().getTotalCount();
        Assertions.assertThat((long)newCount).isEqualTo(oldCount);
    }
}

