/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.branch.BranchCreateRequest;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.search.AbstractNodeSearchEndpointTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.MeshTestHelper;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeSearchEndpointBTest
extends AbstractNodeSearchEndpointTest {
    public NodeSearchEndpointBTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Test
    public void testSearchEnglish() throws Exception {
        this.searchWithLanguages("en");
    }

    @Test
    public void testSearchGerman() throws Exception {
        this.searchWithLanguages("de");
    }

    @Test
    public void testSearchMultipleLanguages() throws Exception {
        this.searchWithLanguages("de", "en");
    }

    @Test
    public void testSearchMicronodeResolveLinks() throws Exception {
        this.addMicronodeField();
        this.recreateIndices();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.vcard.fields-vcard.firstName", "Mickey"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new NodeParametersImpl().setResolveLinks(LinkType.FULL), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Check returned search results", (long)1L, (long)response.getData().size());
        Assert.assertEquals((String)"Check total search results", (long)1L, (long)response.getMetainfo().getTotalCount());
        try (Tx tx = this.tx();){
            for (NodeResponse nodeResponse : response.getData()) {
                Assert.assertNotNull((String)"Returned node must not be null", (Object)nodeResponse);
                Assert.assertEquals((String)"Check result uuid", (Object)this.content("concorde").getUuid(), (Object)nodeResponse.getUuid());
            }
        }
    }

    @Test
    public void testSearchListOfMicronodes() throws Exception {
        this.addMicronodeListField();
        this.recreateIndices();
        for (String firstName : Arrays.asList("Mickey", "Donald")) {
            for (String lastName : Arrays.asList("Mouse", "Duck")) {
                boolean expectResult = firstName.substring(0, 1).equals(lastName.substring(0, 1));
                NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", this.getNestedVCardListSearch(firstName, lastName), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new VersioningParametersImpl().draft()}));
                if (expectResult) {
                    Assert.assertEquals((String)"Check returned search results", (long)1L, (long)response.getData().size());
                    Assert.assertEquals((String)"Check total search results", (long)1L, (long)response.getMetainfo().getTotalCount());
                    for (NodeResponse nodeResponse : response.getData()) {
                        Assert.assertNotNull((String)"Returned node must not be null", (Object)nodeResponse);
                        Assert.assertEquals((String)"Check result uuid", (Object)this.db().tx(() -> this.content("concorde").getUuid()), (Object)nodeResponse.getUuid());
                    }
                    continue;
                }
                Assert.assertEquals((String)"Check returned search results", (long)0L, (long)response.getData().size());
                Assert.assertEquals((String)"Check total search results", (long)0L, (long)response.getMetainfo().getTotalCount());
            }
        }
    }

    @Test
    public void testSearchListOfNodes() throws Exception {
        this.addNodeListField();
        this.recreateIndices();
        String nodeUuid = (String)this.tx(() -> this.content("concorde").getUuid());
        String query = MeshTestHelper.getSimpleTermQuery("fields.nodelist", nodeUuid);
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", query, new ParameterProvider[0]));
        Assert.assertEquals((String)"We expected to find the node itself since it contains a node list which includes a item which points to the same node.", (Object)nodeUuid, (Object)((NodeResponse)response.getData().get(0)).getUuid());
    }

    @Test
    public void testSearchDraftInBranch() throws Exception {
        this.grantAdmin();
        this.recreateIndices();
        NodeResponse concorde = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", (String)this.db().tx(() -> this.content("concorde").getUuid()), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        BranchCreateRequest createBranch = new BranchCreateRequest();
        createBranch.setName("newbranch");
        this.waitForLatestJob(() -> ClientHelper.call(() -> this.client().createBranch("dummy", createBranch, new ParameterProvider[0])));
        this.waitForSearchIdleEvent();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", "supersonic"), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        ((AbstractListAssert)Assertions.assertThat((List)response.getData()).as("Search result", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new NodeResponse[]{concorde});
        String branchName = (String)this.db().tx(() -> this.project().getInitialBranch().getName());
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", "supersonic"), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchName).draft()}));
        ((AbstractListAssert)Assertions.assertThat((List)response.getData()).as("Search result", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new NodeResponse[]{concorde});
    }
}

