/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.GenericMessageResponse;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.search.AbstractNodeSearchEndpointTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.MeshTestHelper;
import org.jsoup.Jsoup;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeSearchEndpointCTest
extends AbstractNodeSearchEndpointTest {
    public NodeSearchEndpointCTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Test
    public void testSearchNumberRange() throws Exception {
        int numberValue = 1200;
        this.addNumberSpeedFieldToOneNode(numberValue);
        this.recreateIndices();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getRangeQuery("fields.speed", 100.0, 9000.0), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertEquals((long)1L, (long)response.getData().size());
    }

    @Test
    public void testSearchNumberRange2() throws Exception {
        int numberValue = 1200;
        this.addNumberSpeedFieldToOneNode(numberValue);
        this.tx(tx -> {
            ContentDao contentDao = tx.contentDao();
            contentDao.getLatestDraftFieldContainer(this.content(), this.english()).createNumber("speed").setNumber((Number)Float.valueOf(92.1535f));
        });
        this.recreateIndices();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getRangeQuery("fields.speed", 900.0, 1500.0), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)("We could expect to find the node with the given seed number field since the value {" + numberValue + "} is between the search range."), (long)1L, (long)response.getData().size());
    }

    @Test
    public void testSearchNumberRange3() throws Exception {
        int numberValue = 1200;
        this.addNumberSpeedFieldToOneNode(numberValue);
        this.recreateIndices();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getRangeQuery("fields.speed", 1000.0, 90.0), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"No node should be found since the range is invalid.", (long)0L, (long)response.getData().size());
    }

    @Test
    public void testSearchMicronode() throws Exception {
        this.addMicronodeField();
        this.recreateIndices();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.vcard.fields-vcard.firstName", "Mickey"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Check returned search results", (long)1L, (long)response.getData().size());
        Assert.assertEquals((String)"Check total search results", (long)1L, (long)response.getMetainfo().getTotalCount());
        try (Tx tx = this.tx();){
            for (NodeResponse nodeResponse : response.getData()) {
                Assert.assertNotNull((String)"Returned node must not be null", (Object)nodeResponse);
                Assert.assertEquals((String)"Check result uuid", (Object)this.content("concorde").getUuid(), (Object)nodeResponse.getUuid());
            }
        }
    }

    @Test
    public void testSearchStringFieldNoRaw() throws Exception {
        this.recreateIndices();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleTermQuery("fields.teaser.raw", "Concorde_english_name"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"No results should be found since the raw field was not added to the teaser schema field", (long)0L, (long)response.getData().size());
    }

    @Test
    public void testSearchStringFieldRaw() throws Exception {
        this.addRawToSchemaField();
        this.recreateIndices();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleTermQuery("fields.teaser.raw", "Concorde_english_name"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Check hits for 'supersonic' before update", (long)1L, (long)response.getData().size());
    }

    @Test
    public void testSearchStringFieldRawAfterIndexSync() throws Exception {
        this.addRawToSchemaField();
        this.recreateIndices();
        this.grantAdmin();
        this.waitForEvent(MeshEvent.INDEX_SYNC_FINISHED, () -> {
            GenericMessageResponse message = (GenericMessageResponse)ClientHelper.call(() -> this.client().invokeIndexSync(new ParameterProvider[0]));
            MeshAssertions.assertThat((GenericMessageResponse)message).matches("search_admin_index_sync_invoked", new String[0]);
        });
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleTermQuery("fields.teaser.raw", "Concorde_english_name"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Check hits for 'supersonic' before update", (long)1L, (long)response.getData().size());
    }

    @Test
    public void testSearchHtml() throws Exception {
        this.recreateIndices();
        String newHtml = "ABCD<strong>EF</strong>GHI";
        String newPlain = Jsoup.parse((String)newHtml).text();
        String nodeUuid = (String)this.db().tx(() -> this.content("concorde").getUuid());
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", "supersonic"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Check hits for 'supersonic' before update", (long)1L, (long)response.getData().size());
        NodeUpdateRequest update = new NodeUpdateRequest();
        update.setLanguage("en");
        update.getFields().put("content", (Field)FieldUtil.createHtmlField((String)newHtml));
        update.setVersion("1.0");
        ClientHelper.call(() -> this.client().updateNode("dummy", nodeUuid, update, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", "supersonic"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Check hits for 'supersonic' after update", (long)0L, (long)response.getData().size());
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", newPlain), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)("Check hits for '" + newPlain + "' after update"), (long)1L, (long)response.getData().size());
    }

    @Test
    public void testDocumentUpdate() throws Exception {
        this.recreateIndices();
        String newString = "ABCDEFGHI";
        String nodeUuid = (String)this.db().tx(() -> this.content("concorde").getUuid());
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", "supersonic"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Check hits for 'supersonic' before update", (long)1L, (long)response.getData().size());
        NodeUpdateRequest update = new NodeUpdateRequest();
        update.setLanguage("en");
        update.getFields().put("content", (Field)FieldUtil.createHtmlField((String)newString));
        update.setVersion("1.0");
        ClientHelper.call(() -> this.client().updateNode("dummy", nodeUuid, update, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", "supersonic"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Check hits for 'supersonic' after update", (long)0L, (long)response.getData().size());
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", newString), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)("Check hits for '" + newString + "' after update"), (long)1L, (long)response.getData().size());
    }

    @Test
    public void testSearchContentResolveLinksAndLangFallback() throws Exception {
        this.recreateIndices();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", "the"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new NodeParametersImpl().setResolveLinks(LinkType.FULL).setLanguages(new String[]{"de", "en"}), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((long)1L, (long)response.getData().size());
        Assert.assertEquals((long)1L, (long)response.getMetainfo().getTotalCount());
        for (NodeResponse nodeResponse : response.getData()) {
            Assert.assertNotNull((Object)nodeResponse);
            Assert.assertNotNull((Object)nodeResponse.getUuid());
        }
    }

    @Test
    public void testSearchContentResolveLinks() throws Exception {
        this.recreateIndices();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", "the"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new NodeParametersImpl().setResolveLinks(LinkType.FULL), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((long)1L, (long)response.getData().size());
        Assert.assertEquals((long)1L, (long)response.getMetainfo().getTotalCount());
        for (NodeResponse nodeResponse : response.getData()) {
            Assert.assertNotNull((Object)nodeResponse);
            Assert.assertNotNull((Object)nodeResponse.getUuid());
        }
    }
}

