/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.dao.TagDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.common.GenericMessageResponse;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.micronode.MicronodeResponse;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.project.ProjectCreateRequest;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.MicroschemaReference;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.MicroschemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.core.rest.tag.TagResponse;
import com.gentics.mesh.core.rest.user.NodeReference;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.parameter.impl.PublishParametersImpl;
import com.gentics.mesh.parameter.impl.SchemaUpdateParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.search.AbstractNodeSearchEndpointTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.MeshTestHelper;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractListAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(startServer=true, testSize=TestSize.FULL)
public class NodeSearchEndpointDTest
extends AbstractNodeSearchEndpointTest {
    public NodeSearchEndpointDTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Test
    public void testSearchListOfMicronodesResolveLinks() throws Exception {
        this.addMicronodeListField();
        this.recreateIndices();
        for (String firstName : Arrays.asList("Mickey", "Donald")) {
            for (String lastName : Arrays.asList("Mouse", "Duck")) {
                boolean expectResult = firstName.substring(0, 1).equals(lastName.substring(0, 1));
                NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", this.getNestedVCardListSearch(firstName, lastName), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new NodeParametersImpl().setResolveLinks(LinkType.FULL), new VersioningParametersImpl().draft()}));
                if (expectResult) {
                    Assert.assertEquals((String)"Check returned search results", (long)1L, (long)response.getData().size());
                    Assert.assertEquals((String)"Check total search results", (long)1L, (long)response.getMetainfo().getTotalCount());
                    for (NodeResponse nodeResponse : response.getData()) {
                        Assert.assertNotNull((String)"Returned node must not be null", (Object)nodeResponse);
                        Assert.assertEquals((String)"Check result uuid", (Object)this.db().tx(() -> this.content("concorde").getUuid()), (Object)nodeResponse.getUuid());
                    }
                    continue;
                }
                Assert.assertEquals((String)"Check returned search results", (long)0L, (long)response.getData().size());
                Assert.assertEquals((String)"Check total search results", (long)0L, (long)response.getMetainfo().getTotalCount());
            }
        }
    }

    @Test
    public void testTrigramSearchQuery() throws Exception {
        this.recreateIndices();
        JsonObject query = new JsonObject().put("min_score", (Object)1.0).put("query", (Object)new JsonObject().put("match_phrase", (Object)new JsonObject().put("fields.content", (Object)new JsonObject().put("query", (Object)"Hersteller"))));
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", query.toString(), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new VersioningParametersImpl().draft(), new NodeParametersImpl().setLanguages(new String[]{"de"})}));
        Assert.assertEquals((long)1L, (long)response.getData().size());
        String name = ((NodeResponse)response.getData().get(0)).getFields().getStringField("teaser").getString();
        Assert.assertEquals((Object)"Honda NR german", (Object)name);
    }

    @Test
    public void testSchemaMigrationNodeSearchTest() throws Exception {
        String schemaUuid;
        SchemaUpdateRequest schema;
        this.recreateIndices();
        String uuid = (String)this.db().tx(() -> this.content("concorde").getUuid());
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleTermQuery("uuid", uuid), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(10L)), new NodeParametersImpl().setLanguages(new String[]{"en", "de"}), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"We expect to find the two language versions.", (long)2L, (long)response.getData().size());
        try (Tx tx = this.tx();){
            HibNode concorde = this.content("concorde");
            HibSchemaVersion schemaVersion = (HibSchemaVersion)concorde.getSchemaContainer().getLatestVersion();
            schema = (SchemaUpdateRequest)JsonUtil.readValue((String)schemaVersion.getJson(), SchemaUpdateRequest.class);
            schema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"extraField"));
            schemaUuid = concorde.getSchemaContainer().getUuid();
        }
        this.mesh().serverSchemaStorage().clear();
        GenericMessageResponse message = (GenericMessageResponse)ClientHelper.call(() -> this.client().updateSchema(schemaUuid, schema, new ParameterProvider[]{new SchemaUpdateParametersImpl().setUpdateAssignedBranches(false)}));
        MeshAssertions.assertThat((GenericMessageResponse)message).matches("schema_updated_migration_deferred", new String[]{"content", "2.0"});
        SchemaResponse updatedSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        this.grantAdmin();
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", (String)this.db().tx(() -> this.project().getLatestBranch().getUuid()), new SchemaReference[]{((SchemaReference)new SchemaReferenceImpl().setUuid(updatedSchema.getUuid())).setVersion(updatedSchema.getVersion())})), JobStatus.COMPLETED, 1);
        this.revokeAdmin();
        this.waitForSearchIdleEvent();
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleTermQuery("uuid", uuid), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(10L)), new NodeParametersImpl().setLanguages(new String[]{"en", "de"}), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)("We only expect to find the two language versions while searching for uuid {" + uuid + "}"), (long)2L, (long)response.getData().size());
    }

    @Test
    public void testSearchManyNodesWithMicronodes() throws Exception {
        long numAdditionalNodes = 99L;
        String branchUuid = (String)this.tx(() -> this.project().getLatestBranch().getUuid());
        this.addMicronodeField();
        String english = this.english();
        NodeReference parentNode = (NodeReference)this.tx(tx -> tx.nodeDao().getParentNode(this.content("concorde"), branchUuid).transformToMinimalReference());
        HibSchemaVersion schemaVersion = (HibSchemaVersion)this.tx(() -> (HibSchemaVersion)this.content("concorde").getSchemaContainer().getLatestVersion());
        NodeResponse request = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid(this.projectName(), this.content("concorde").getUuid(), new ParameterProvider[0]));
        int i = 0;
        while ((long)i < numAdditionalNodes) {
            NodeCreateRequest createRequest = new NodeCreateRequest();
            createRequest.setSchema((SchemaReference)this.tx(() -> schemaVersion.transformToReference()));
            MicronodeResponse micronodeField = new MicronodeResponse();
            micronodeField.getFields().putAll(Map.of("firstName", new StringFieldImpl().setString("Mickey"), "lastName", new StringFieldImpl().setString("Mouse")));
            micronodeField.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
            FieldMap fieldMap = request.getFields().putAll(Map.of("slug", new StringFieldImpl().setString("Name_" + i), "vcard", micronodeField));
            createRequest.setFields(fieldMap);
            createRequest.setParentNode(parentNode);
            createRequest.setLanguage(english);
            ClientHelper.call(() -> this.client().createNode(this.projectName(), createRequest, new ParameterProvider[0]));
            ++i;
        }
        this.recreateIndices();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.vcard.fields-vcard.firstName", "Mickey"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(numAdditionalNodes + 1L)), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Check returned search results", (long)(numAdditionalNodes + 1L), (long)response.getData().size());
    }

    @Test
    public void testTagCount() throws Exception {
        this.recreateIndices();
        HibNode node = (HibNode)this.tx(() -> this.content("concorde"));
        long previousTagCount = (Long)this.tx(tx -> {
            TagDao tagDao = tx.tagDao();
            return tagDao.getTags(node, this.project().getLatestBranch()).count();
        });
        int tagCount = 20;
        for (int i = 0; i < tagCount; ++i) {
            TagResponse tagResponse = this.createTag("dummy", (String)this.tx(() -> this.tagFamily("colors").getUuid()), "tag" + i);
            ClientHelper.call(() -> this.client().addTagToNode("dummy", node.getUuid(), tagResponse.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        }
        this.waitForSearchIdleEvent();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", "Concorde"), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Expect to only get one search result", (long)1L, (long)response.getMetainfo().getTotalCount());
        long nColorTags = ((NodeResponse)response.getData().get(0)).getTags().stream().filter(ref -> ref.getTagFamily().equals("colors")).count();
        long nBasicTags = ((NodeResponse)response.getData().get(0)).getTags().stream().filter(ref -> ref.getTagFamily().equals("basic")).count();
        Assert.assertEquals((String)"Expect correct tag count", (long)(previousTagCount + (long)tagCount), (long)(nColorTags + nBasicTags));
    }

    @Test
    public void testGlobalNodeSearch() throws Exception {
        this.recreateIndices();
        NodeResponse oldNode = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", (String)this.tx(() -> this.content("concorde").getUuid()), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        ProjectCreateRequest createProject = new ProjectCreateRequest();
        createProject.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
        createProject.setName("mynewproject");
        ProjectResponse projectResponse = (ProjectResponse)ClientHelper.call(() -> this.client().createProject(createProject));
        NodeCreateRequest createNode = new NodeCreateRequest();
        createNode.setLanguage("en");
        createNode.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
        createNode.setParentNode(projectResponse.getRootNode());
        createNode.getFields().put("slug", (Field)FieldUtil.createStringField((String)"newNode"));
        createNode.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"newTeaser"));
        createNode.getFields().put("content", (Field)FieldUtil.createHtmlField((String)"Concorde"));
        NodeResponse newNode = (NodeResponse)ClientHelper.call(() -> this.client().createNode("mynewproject", createNode, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", "Concorde"), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        ((AbstractListAssert)MeshAssertions.assertThat((List)response.getData()).as("Search result in dummy", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new NodeResponse[]{oldNode});
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("mynewproject", MeshTestHelper.getSimpleQuery("fields.content", "Concorde"), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        ((AbstractListAssert)MeshAssertions.assertThat((List)response.getData()).as("Search result in mynewproject", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new NodeResponse[]{newNode});
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes(MeshTestHelper.getSimpleQuery("fields.content", "Concorde"), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        ((AbstractListAssert)MeshAssertions.assertThat((List)response.getData()).as("Global search result", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new NodeResponse[]{newNode, oldNode});
    }

    @Test
    public void testTakeDraftOffline() throws Exception {
        this.recreateIndices();
        ProjectCreateRequest createProject = new ProjectCreateRequest();
        createProject.setName("mynewproject");
        createProject.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        ProjectResponse projectResponse = (ProjectResponse)ClientHelper.call(() -> this.client().createProject(createProject));
        NodeCreateRequest createNode = new NodeCreateRequest();
        createNode.setLanguage("en");
        createNode.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        createNode.setParentNode(projectResponse.getRootNode());
        createNode.getFields().put("name", (Field)FieldUtil.createStringField((String)"AwesomeString"));
        NodeResponse newNode = (NodeResponse)ClientHelper.call(() -> this.client().createNode("mynewproject", createNode, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes(MeshTestHelper.getSimpleQuery("fields.name", "AwesomeString"), new ParameterProvider[]{new VersioningParametersImpl().setVersion("published")}));
        MeshAssertions.assertThat((List)response.getData()).as("Global search result before publishing", new Object[0]).isEmpty();
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes(MeshTestHelper.getSimpleQuery("fields.name", "AwesomeString"), new ParameterProvider[]{new VersioningParametersImpl().setVersion("draft")}));
        ((AbstractListAssert)MeshAssertions.assertThat((List)response.getData()).as("Global search result after publishing", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new NodeResponse[]{newNode});
        String baseUuid = (String)this.db().tx(() -> this.project().getBaseNode().getUuid());
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", baseUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        this.waitForSearchIdleEvent();
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes(MeshTestHelper.getSimpleQuery("fields.name", "AwesomeString"), new ParameterProvider[]{new VersioningParametersImpl().setVersion("draft")}));
        ((AbstractListAssert)MeshAssertions.assertThat((List)response.getData()).as("Global search result after publishing", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new NodeResponse[]{newNode});
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes(MeshTestHelper.getSimpleQuery("fields.name", "AwesomeString"), new ParameterProvider[]{new VersioningParametersImpl().setVersion("published")}));
        MeshAssertions.assertThat((List)response.getData()).as("Global search result before publishing", new Object[0]).isEmpty();
    }

    @Test
    public void testGlobalPublishedNodeSearch() throws Exception {
        this.recreateIndices();
        ProjectCreateRequest createProject = new ProjectCreateRequest();
        createProject.setName("mynewproject");
        createProject.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        ProjectResponse projectResponse = (ProjectResponse)ClientHelper.call(() -> this.client().createProject(createProject));
        NodeCreateRequest createNode = new NodeCreateRequest();
        createNode.setLanguage("en");
        createNode.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        createNode.setParentNodeUuid(projectResponse.getRootNode().getUuid());
        createNode.getFields().put("name", (Field)FieldUtil.createStringField((String)"AwesomeString"));
        NodeResponse newNode = (NodeResponse)ClientHelper.call(() -> this.client().createNode("mynewproject", createNode, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes(MeshTestHelper.getSimpleQuery("fields.name", "AwesomeString"), new ParameterProvider[]{new VersioningParametersImpl().setVersion("published")}));
        MeshAssertions.assertThat((List)response.getData()).as("Global search result before publishing", new Object[0]).isEmpty();
        ClientHelper.call(() -> this.client().publishNode("mynewproject", newNode.getUuid(), new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes(MeshTestHelper.getSimpleQuery("fields.name", "AwesomeString"), new ParameterProvider[]{new VersioningParametersImpl().setVersion("published")}));
        ((AbstractListAssert)MeshAssertions.assertThat((List)response.getData()).as("Global search result after publishing", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new NodeResponse[]{newNode});
        String baseUuid = (String)this.db().tx(() -> this.project().getBaseNode().getUuid());
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", baseUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        this.waitForSearchIdleEvent();
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes(MeshTestHelper.getSimpleQuery("fields.name", "AwesomeString"), new ParameterProvider[0]));
        ((AbstractListAssert)MeshAssertions.assertThat((List)response.getData()).as("Global search result after publishing", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new NodeResponse[]{newNode});
    }
}

