/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.rest.client.MeshRequest;
import com.gentics.mesh.search.AbstractNodeSearchEndpointTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.MeshTestHelper;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.FULL, startServer=true)
public class NodeSearchEndpointETest
extends AbstractNodeSearchEndpointTest {
    public NodeSearchEndpointETest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Test
    public void testDocumentDeletion() throws Exception {
        this.recreateIndices();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", "Concorde"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((long)1L, (long)response.getData().size());
        this.deleteNode("dummy", (String)this.db().tx(() -> this.content("concorde").getUuid()));
        this.waitForSearchIdleEvent();
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", "Concorde"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"We added the delete action and therefore the document should no longer be part of the index.", (long)0L, (long)response.getData().size());
    }

    @Test
    public void testBogusQuery() {
        ClientHelper.call(() -> this.client().searchNodes("dummy", "bogus}J}son", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"search_query_not_parsable", (String[])new String[0]);
    }

    @Test
    public void testCustomQuery() throws Exception {
        this.recreateIndices();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleTermQuery("schema.name.raw", "content"), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertNotNull((Object)response);
        Assert.assertFalse((boolean)response.getData().isEmpty());
    }

    @Test
    public void testSearchForChildNodes() throws Exception {
        this.recreateIndices();
        String parentNodeUuid = (String)this.db().tx(() -> this.folder("news").getUuid());
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleTermQuery("parentNode.uuid", parentNodeUuid), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertNotNull((Object)response);
        Assert.assertFalse((boolean)response.getData().isEmpty());
    }

    @Test
    public void testDocumentCreation() throws Exception {
        this.recreateIndices();
        Object json = "{";
        json = (String)json + "\t\t\t\t\"sort\" : {";
        json = (String)json + "\t\t\t      \"created\" : {\"order\" : \"asc\"}";
        json = (String)json + "\t\t\t    },";
        json = (String)json + "\t\t\t    \"query\":{";
        json = (String)json + "\t\t\t        \"bool\" : {";
        json = (String)json + "\t\t\t            \"must\" : {";
        json = (String)json + "\t\t\t                \"term\" : { \"fields.name\" : \"bla\" }";
        json = (String)json + "\t\t\t            }";
        json = (String)json + "\t\t\t        }";
        json = (String)json + "\t\t\t    }";
        Object search = json = (String)json + "\t\t\t}";
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.lambda$testDocumentCreation$7((String)search));
        Assert.assertEquals((long)0L, (long)response.getData().size());
        NodeCreateRequest create = new NodeCreateRequest();
        create.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName("folder")).setUuid((String)this.db().tx(() -> this.schemaContainer("folder").getUuid())));
        create.setLanguage("en");
        create.getFields().put("name", (Field)FieldUtil.createStringField((String)"bla"));
        create.setParentNodeUuid((String)this.db().tx(() -> this.folder("2015").getUuid()));
        ClientHelper.call(() -> this.client().createNode("dummy", create, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        response = (NodeListResponse)ClientHelper.call(() -> this.lambda$testDocumentCreation$11((String)search));
        Assert.assertEquals((String)"Check search result after document creation", (long)1L, (long)response.getData().size());
    }

    private /* synthetic */ MeshRequest lambda$testDocumentCreation$11(String search) throws Exception {
        return this.client().searchNodes("dummy", search, new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new VersioningParametersImpl().draft()});
    }

    private /* synthetic */ MeshRequest lambda$testDocumentCreation$7(String search) throws Exception {
        return this.client().searchNodes("dummy", search, new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new VersioningParametersImpl().draft()});
    }
}

