/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.search.AbstractNodeSearchEndpointTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.MeshTestHelper;
import java.time.Instant;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeSearchEndpointFTest
extends AbstractNodeSearchEndpointTest {
    public NodeSearchEndpointFTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Test
    public void testSearchAndSort() throws Exception {
        this.recreateIndices();
        String query = this.getESText("contentSchemaTermQuery.es");
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", query, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertNotNull((Object)response);
        Assert.assertFalse((boolean)response.getData().isEmpty());
        long lastCreated = 0L;
        for (NodeResponse nodeResponse : response.getData()) {
            Date date = Date.from(Instant.parse(nodeResponse.getCreated()));
            if (lastCreated > date.getTime()) {
                Assert.fail((String)("Found entry that was not sorted by create timestamp. Last entry: {" + lastCreated + "} current entry: {" + nodeResponse.getCreated() + "}"));
            } else {
                lastCreated = date.getTime();
            }
            Assert.assertEquals((Object)"content", (Object)nodeResponse.getSchema().getName());
        }
    }

    @Test
    public void testSearchContent() throws Exception {
        this.recreateIndices();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", "the"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((long)1L, (long)response.getData().size());
        Assert.assertEquals((long)1L, (long)response.getMetainfo().getTotalCount());
        for (NodeResponse nodeResponse : response.getData()) {
            Assert.assertNotNull((Object)nodeResponse);
            Assert.assertNotNull((Object)nodeResponse.getUuid());
        }
    }

    @Test
    public void testSearchMissingVertex() throws Exception {
        this.recreateIndices();
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            BulkActionContext context = this.createBulkContext();
            nodeDao.delete(this.content("honda nr"), context, false, true);
            tx.success();
        }
        this.waitForSearchIdleEvent();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes(MeshTestHelper.getSimpleQuery("fields.content", "the"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L))}));
        Assert.assertEquals((long)0L, (long)response.getData().size());
        Assert.assertEquals((long)0L, (long)response.getMetainfo().getTotalCount());
    }

    @Test
    public void testSearchWithManySchemas() {
        for (int i = 0; i < 45; ++i) {
            SchemaCreateRequest request = new SchemaCreateRequest();
            request.setName("dummy" + i);
            request.addField((FieldSchema)FieldUtil.createHtmlFieldSchema((String)"content"));
            SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", response.getUuid()));
        }
        this.waitForSearchIdleEvent();
        ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", "the"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new VersioningParametersImpl().draft()}));
    }
}

