/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.rest.branch.BranchCreateRequest;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.micronode.MicronodeResponse;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaCreateRequest;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaResponse;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaUpdateRequest;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.MicroschemaReference;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.MicroschemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.core.rest.user.NodeReference;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.search.AbstractNodeSearchEndpointTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.MeshTestHelper;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeSearchEndpointGTest
extends AbstractNodeSearchEndpointTest {
    public NodeSearchEndpointGTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Test
    public void testSearchDraftNodes() throws Exception {
        this.recreateIndices();
        String oldContent = "supersonic";
        String newContent = "urschnell";
        String uuid = (String)this.db().tx(() -> this.content("concorde").getUuid());
        NodeResponse concorde = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", oldContent), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        ((AbstractListAssert)Assertions.assertThat((List)response.getData()).as("Search result", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new NodeResponse[]{concorde});
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", newContent), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assertions.assertThat((List)response.getData()).as("Search result", new Object[0]).isEmpty();
        NodeUpdateRequest update = new NodeUpdateRequest();
        update.setLanguage("en");
        update.getFields().put("content", (Field)FieldUtil.createHtmlField((String)newContent));
        update.setVersion("1.0");
        ClientHelper.call(() -> this.client().updateNode("dummy", concorde.getUuid(), update, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", oldContent), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assertions.assertThat((List)response.getData()).as("Search result", new Object[0]).isEmpty();
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", newContent), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        ((AbstractListAssert)Assertions.assertThat((List)response.getData()).as("Search result", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new NodeResponse[]{concorde});
    }

    @Test
    public void testMicronodeMigrationSearch() throws Exception {
        this.recreateIndices();
        NodeListResponse response1 = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", "supersonic"), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assertions.assertThat((List)response1.getData()).as("Search result", new Object[0]).isNotEmpty();
        String contentUuid = (String)this.db().tx(() -> this.content().getUuid());
        String folderUuid = (String)this.db().tx(() -> this.folder("2015").getUuid());
        String schemaUuid = (String)this.db().tx(() -> this.schemaContainer("content").getUuid());
        SchemaUpdateRequest schemaUpdate = (SchemaUpdateRequest)this.db().tx(() -> (SchemaUpdateRequest)JsonUtil.readValue((String)((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getJson(), SchemaUpdateRequest.class));
        MicroschemaCreateRequest microschemaRequest = new MicroschemaCreateRequest();
        microschemaRequest.setName("TestMicroschema");
        microschemaRequest.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"text"));
        microschemaRequest.addField((FieldSchema)FieldUtil.createNodeFieldSchema((String)"nodeRef").setAllowedSchemas(new String[]{"content"}));
        MicroschemaResponse microschemaResponse = (MicroschemaResponse)ClientHelper.call(() -> this.client().createMicroschema(microschemaRequest));
        String microschemaUuid = microschemaResponse.getUuid();
        schemaUpdate.addField((FieldSchema)FieldUtil.createMicronodeFieldSchema((String)"micro").setAllowedMicroSchemas(new String[]{"TestMicroschema"}));
        this.grantAdmin();
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(schemaUuid, schemaUpdate, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        this.revokeAdmin();
        this.waitForSearchIdleEvent();
        NodeListResponse response2 = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", "supersonic"), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assertions.assertThat((List)response2.getData()).as("Search result", new Object[0]).isNotEmpty();
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setParentNode(new NodeReference().setUuid(folderUuid));
        nodeCreateRequest.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
        nodeCreateRequest.getFields().put("title", (Field)FieldUtil.createStringField((String)"someTitle"));
        nodeCreateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"someTeaser"));
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"someSlug"));
        MicronodeResponse micronodeField = new MicronodeResponse();
        micronodeField.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("TestMicroschema"));
        micronodeField.getFields().put("text", (Field)FieldUtil.createStringField((String)"someText"));
        micronodeField.getFields().put("nodeRef", (Field)FieldUtil.createNodeField((String)contentUuid));
        nodeCreateRequest.getFields().put("micro", (Field)micronodeField);
        NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        Assert.assertEquals((Object)"someText", (Object)nodeResponse.getFields().getMicronodeField("micro").getFields().getStringField("text").getString());
        MicroschemaUpdateRequest microschemaUpdate = new MicroschemaUpdateRequest();
        microschemaUpdate.setName("TestMicroschema");
        microschemaUpdate.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"textNew"));
        microschemaUpdate.addField((FieldSchema)FieldUtil.createNodeFieldSchema((String)"nodeRefNew").setAllowedSchemas(new String[]{"content"}));
        this.grantAdmin();
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateMicroschema(microschemaUuid, microschemaUpdate, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        this.revokeAdmin();
        NodeUpdateRequest updateRequest = new NodeUpdateRequest();
        updateRequest.setLanguage("en");
        updateRequest.setVersion("0.2");
        micronodeField = new MicronodeResponse();
        micronodeField.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("TestMicroschema"));
        micronodeField.getFields().put("textNew", (Field)FieldUtil.createStringField((String)"someNewText"));
        micronodeField.getFields().put("nodeRefNew", (Field)FieldUtil.createNodeField((String)contentUuid));
        updateRequest.getFields().put("micro", (Field)micronodeField);
        ClientHelper.call(() -> this.client().updateNode("dummy", nodeResponse.getUuid(), updateRequest, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        NodeResponse nodeResponse2 = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", nodeResponse.getUuid(), new ParameterProvider[0]));
        Assert.assertEquals((Object)"someNewText", (Object)nodeResponse2.getFields().getMicronodeField("micro").getFields().getStringField("textNew").getString());
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", "supersonic"), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assertions.assertThat((List)response.getData()).as("Search result", new Object[0]).isNotEmpty();
    }

    @Test
    public void testSearchPublishedInBranch() throws Exception {
        this.grantAdmin();
        this.recreateIndices();
        String uuid = (String)this.tx(() -> this.content("concorde").getUuid());
        NodeResponse concorde = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        ClientHelper.call(() -> this.client().publishNode("dummy", uuid, new ParameterProvider[0]));
        String branchName = "newbranch";
        BranchCreateRequest createBranch = new BranchCreateRequest();
        createBranch.setName(branchName);
        this.waitForLatestJob(() -> ClientHelper.call(() -> this.client().createBranch("dummy", createBranch, new ParameterProvider[0])));
        this.waitForSearchIdleEvent();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", "supersonic"), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchName).setVersion("published")}));
        ((AbstractListAssert)Assertions.assertThat((List)response.getData()).as("Search result", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new NodeResponse[]{concorde});
    }

    @Test
    public void testSearchTagFamilies() throws Exception {
        this.recreateIndices();
        String query = this.getESText("tagFamilySearch.es");
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", query, new ParameterProvider[0]));
        Assertions.assertThat((List)response.getData()).isNotEmpty();
        for (NodeResponse node : response.getData()) {
            long count = node.getTags().stream().filter(tag -> tag.getName().equals("red")).count();
            ((AbstractLongAssert)Assertions.assertThat((long)count).as("The node should have the tag 'red'.", new Object[0])).isGreaterThanOrEqualTo(1L);
        }
    }
}

