/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.search.AbstractNodeSearchEndpointTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshCoreOptionChanger;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.MeshTestHelper;
import io.vertx.core.json.JsonObject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true, optionChanger=MeshCoreOptionChanger.ES_STRICT_MODE)
public class NodeSearchEndpointStrictModeTest
extends AbstractNodeSearchEndpointTest {
    public NodeSearchEndpointStrictModeTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Test
    public void testSearchStringFieldRaw() throws Exception {
        this.addCustomMapping();
        this.recreateIndices();
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleTermQuery("fields.teaser", "Concorde_english_name"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Check hits for 'supersonic' before update", (long)1L, (long)response.getData().size());
    }

    private void addCustomMapping() {
        String schemaUuid = (String)this.tx(() -> this.content().getSchemaContainer().getUuid());
        SchemaUpdateRequest request = (SchemaUpdateRequest)this.tx(() -> (SchemaUpdateRequest)JsonUtil.readValue((String)((HibSchemaVersion)this.content().getSchemaContainer().getLatestVersion()).getJson(), SchemaUpdateRequest.class));
        JsonObject keywordMapping = new JsonObject().put("index", (Object)true).put("type", (Object)"keyword");
        request.getField("teaser").setElasticsearch(keywordMapping);
        this.grantAdmin();
        this.waitForJob(() -> ClientHelper.call(() -> this.client().updateSchema(schemaUuid, request, new ParameterProvider[0])));
        this.revokeAdmin();
    }
}

