/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.common.GenericMessageResponse;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.rest.client.MeshRestClientMessageException;
import com.gentics.mesh.search.AbstractNodeSearchEndpointTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(startServer=true, testSize=TestSize.FULL)
public class NodeTagSearchEndpointTest
extends AbstractNodeSearchEndpointTest {
    public NodeTagSearchEndpointTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Test
    public void testSearchNodeByTag() throws Exception {
        try (Tx tx = this.tx();){
            this.recreateIndices();
        }
        String query = this.getESText("tag.es");
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", query, new ParameterProvider[0]));
        Assertions.assertThat((List)response.getData()).isNotEmpty();
    }

    @Test
    public void testFailingQuery() throws Exception {
        try (Tx tx = this.tx();){
            this.recreateIndices();
        }
        String query = this.getESText("failing-query.es");
        MeshRestClientMessageException error = ClientHelper.call(() -> this.client().searchNodes("dummy", query, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"search_error_query", (String[])new String[0]);
        GenericMessageResponse message = error.getResponseMessage();
        Assert.assertNotNull((String)"Detailed info not found", message.getProperties().get("cause-0"));
        System.out.println(message.toJson());
    }

    @Test
    public void testSearchNodaeByMultipleTagsNullPage() throws Exception {
        try (Tx tx = this.tx();){
            this.recreateIndices();
        }
        String query = this.getESText("tags.es");
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", query, new ParameterProvider[]{new PagingParametersImpl().setPerPage(Long.valueOf(0L))}));
        Assertions.assertThat((List)response.getData()).isEmpty();
        Assert.assertEquals((long)1L, (long)response.getMetainfo().getPageCount());
    }

    @Test
    public void testSearchNodeByMultipleTags4() throws Exception {
        try (Tx tx = this.tx();){
            this.recreateIndices();
        }
        String query = this.getESText("tags.es");
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", query, new ParameterProvider[0]));
        ((AbstractListAssert)Assertions.assertThat((List)response.getData()).isNotEmpty()).hasSize(1);
        String title = ((NodeResponse)response.getData().get(0)).getFields().getStringField("title").getString();
        Assert.assertEquals((Object)"Concorde english title", (Object)title);
    }
}

