/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.project.ProjectListResponse;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.search.AbstractMultiESTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.test.definition.BasicSearchCrudTestcases;
import org.codehaus.jettison.json.JSONException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(startServer=true, testSize=TestSize.FULL)
public class ProjectSearchEndpointTest
extends AbstractMultiESTest
implements BasicSearchCrudTestcases {
    public ProjectSearchEndpointTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Test
    public void testSearchProject() throws Exception {
        try (Tx tx = this.tx();){
            this.recreateIndices();
        }
        this.waitForSearchIdleEvent();
        ProjectListResponse response = (ProjectListResponse)this.client().searchProjects(MeshTestHelper.getSimpleQuery("name", "dummy"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L))}).blockingGet();
        Assert.assertEquals((long)1L, (long)response.getData().size());
        response = (ProjectListResponse)this.client().searchProjects(MeshTestHelper.getSimpleQuery("name", "blub"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L))}).blockingGet();
        Assert.assertEquals((long)0L, (long)response.getData().size());
        response = (ProjectListResponse)this.client().searchProjects(MeshTestHelper.getSimpleTermQuery("name.raw", "dummy"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L))}).blockingGet();
        Assert.assertEquals((long)1L, (long)response.getData().size());
    }

    @Override
    @Test
    public void testDocumentCreation() throws Exception {
        String newName = "newproject";
        ProjectResponse project = this.createProject("newproject");
        try (Tx tx = this.tx();){
            Assert.assertNotNull((Object)tx.projectDao().findByUuid(project.getUuid()));
        }
        this.waitForSearchIdleEvent();
        ProjectListResponse response = (ProjectListResponse)ClientHelper.call(() -> this.client().searchProjects(MeshTestHelper.getSimpleTermQuery("name.raw", "newproject"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L))}));
        Assert.assertEquals((long)1L, (long)response.getData().size());
    }

    @Override
    @Test
    public void testDocumentDeletion() throws InterruptedException, JSONException {
        String projectName = "newproject";
        ProjectResponse project = this.createProject("newproject");
        this.waitForSearchIdleEvent();
        ProjectListResponse response = (ProjectListResponse)this.client().searchProjects(MeshTestHelper.getSimpleTermQuery("name.raw", "newproject"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L))}).blockingGet();
        Assert.assertEquals((long)1L, (long)response.getData().size());
        this.deleteProject(project.getUuid());
        this.waitForSearchIdleEvent();
        response = (ProjectListResponse)this.client().searchProjects(MeshTestHelper.getSimpleTermQuery("name.raw", "newproject"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L))}).blockingGet();
        Assert.assertEquals((long)0L, (long)response.getData().size());
    }

    @Override
    @Test
    public void testDocumentUpdate() throws InterruptedException, JSONException {
        String projectName = "newproject";
        ProjectResponse project = this.createProject("newproject");
        String newProjectName = "updatedprojectname";
        this.updateProject(project.getUuid(), newProjectName);
        this.waitForSearchIdleEvent();
        ProjectListResponse response = (ProjectListResponse)this.client().searchProjects(MeshTestHelper.getSimpleTermQuery("name.raw", "newproject"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L))}).blockingGet();
        Assert.assertEquals((long)0L, (long)response.getData().size());
        this.waitForSearchIdleEvent();
        response = (ProjectListResponse)this.client().searchProjects(MeshTestHelper.getSimpleTermQuery("name.raw", newProjectName), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L))}).blockingGet();
        Assert.assertEquals((long)1L, (long)response.getData().size());
    }
}

