/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.core.rest.project.ProjectListResponse;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.role.RolePermissionRequest;
import com.gentics.mesh.core.rest.role.RoleResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.search.AbstractMultiESTest;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.MeshTestHelper;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(startServer=true, testSize=TestSize.PROJECT)
public class RoleDeleteSyncTest
extends AbstractMultiESTest {
    public RoleDeleteSyncTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Test
    public void testSyncAfterDeletedRole() throws Exception {
        this.recreateIndices();
        RoleResponse role = this.createRole("testRole");
        ProjectResponse project = this.getProject();
        this.client().updateRolePermissions(role.getUuid(), "/projects/" + project.getUuid(), RolePermissionRequest.grantAll()).blockingAwait();
        this.client().deleteRole(role.getUuid()).blockingAwait();
        this.recreateIndices();
        ProjectListResponse response = (ProjectListResponse)this.client().searchProjects(MeshTestHelper.getSimpleQuery("name", "dummy"), new ParameterProvider[0]).blockingGet();
        Assertions.assertThat((List)response.getData()).isNotEmpty();
    }
}

