/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.core.rest.role.RoleListResponse;
import com.gentics.mesh.core.rest.role.RoleResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.search.AbstractMultiESTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.test.definition.BasicSearchCrudTestcases;
import org.codehaus.jettison.json.JSONException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(startServer=true, testSize=TestSize.PROJECT)
public class RoleSearchEndpointTest
extends AbstractMultiESTest
implements BasicSearchCrudTestcases {
    public RoleSearchEndpointTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Override
    @Test
    public void testDocumentCreation() throws InterruptedException, JSONException {
        String roleName = "rolename42a";
        this.createRole(roleName, (String)this.db().tx(() -> this.group().getUuid()));
        this.waitForSearchIdleEvent();
        RoleListResponse list = (RoleListResponse)ClientHelper.call(() -> this.client().searchRoles(MeshTestHelper.getSimpleTermQuery("name.raw", roleName), new ParameterProvider[0]));
        Assert.assertEquals((long)1L, (long)list.getData().size());
    }

    @Override
    @Test
    public void testDocumentDeletion() throws InterruptedException, JSONException {
        String roleName = "rolename42a";
        RoleResponse role = this.createRole(roleName, (String)this.db().tx(() -> this.group().getUuid()));
        this.waitForSearchIdleEvent();
        RoleListResponse list = (RoleListResponse)ClientHelper.call(() -> this.client().searchRoles(MeshTestHelper.getSimpleTermQuery("name.raw", roleName), new ParameterProvider[0]));
        Assert.assertEquals((long)1L, (long)list.getData().size());
        this.deleteRole(role.getUuid());
        this.waitForSearchIdleEvent();
        list = (RoleListResponse)ClientHelper.call(() -> this.client().searchRoles(MeshTestHelper.getSimpleTermQuery("name.raw", roleName), new ParameterProvider[0]));
        Assert.assertEquals((long)0L, (long)list.getData().size());
    }

    @Override
    @Test
    public void testDocumentUpdate() throws InterruptedException, JSONException {
        String roleName = "rolename42a";
        RoleResponse role = this.createRole(roleName, (String)this.db().tx(() -> this.group().getUuid()));
        this.waitForSearchIdleEvent();
        RoleListResponse list = (RoleListResponse)ClientHelper.call(() -> this.client().searchRoles(MeshTestHelper.getSimpleTermQuery("name.raw", roleName), new ParameterProvider[0]));
        Assert.assertEquals((long)1L, (long)list.getData().size());
        String newRoleName = "updatedrolename";
        this.updateRole(role.getUuid(), newRoleName);
        this.waitForSearchIdleEvent();
        list = (RoleListResponse)ClientHelper.call(() -> this.client().searchRoles(MeshTestHelper.getSimpleTermQuery("name.raw", newRoleName), new ParameterProvider[0]));
        Assert.assertEquals((long)1L, (long)list.getData().size());
        list = (RoleListResponse)ClientHelper.call(() -> this.client().searchRoles(MeshTestHelper.getSimpleTermQuery("name.raw", roleName), new ParameterProvider[0]));
        Assert.assertEquals((long)0L, (long)list.getData().size());
    }
}

