/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.schema.SchemaListResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.SchemaUpdateParameters;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.search.AbstractMultiESTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.test.definition.BasicSearchCrudTestcases;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Verticle;
import java.util.Arrays;
import org.codehaus.jettison.json.JSONException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class SchemaSearchEndpointTest
extends AbstractMultiESTest
implements BasicSearchCrudTestcases {
    public SchemaSearchEndpointTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Before
    public void setupWorkerVerticle() throws Exception {
        DeploymentOptions options = new DeploymentOptions();
        options.setWorker(true);
        this.vertx().deployVerticle((Verticle)this.meshDagger().jobWorkerVerticle(), options);
    }

    @After
    public void removeWorkerVerticle() throws Exception {
        this.meshDagger().jobWorkerVerticle().stop();
    }

    @Test
    public void testEmptySchema() throws Exception {
        String SCHEMA_NAME = "TestSchema";
        String parentNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        this.grantAdmin();
        try (Tx tx = this.tx();){
            this.recreateIndices();
        }
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setName("TestSchema");
        SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]));
        String uuid = response.getUuid();
        ClientHelper.call(() -> this.client().assignSchemaToProject(this.projectName(), uuid));
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setSchemaName("TestSchema");
        nodeCreateRequest.setParentNodeUuid(parentNodeUuid);
        NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode(this.projectName(), nodeCreateRequest, new ParameterProvider[0]));
        this.waitForJob(() -> {
            SchemaUpdateRequest updateRequest = response.toUpdateRequest();
            updateRequest.setDescription("Some Description");
            updateRequest.setFields(Arrays.asList(FieldUtil.createStringFieldSchema((String)"test")));
            ClientHelper.call(() -> this.client().updateSchema(uuid, updateRequest, new ParameterProvider[0]));
        });
        this.waitForSearchIdleEvent();
        String version = ((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid(this.projectName(), nodeResponse.getUuid(), new ParameterProvider[0]))).getVersion();
        System.out.println("version:" + version);
        Assert.assertEquals((String)"The version should be bumped via the migration.", (Object)"0.2", (Object)version);
        NodeListResponse searchResponse = (NodeListResponse)this.client().searchNodes(MeshTestHelper.getUuidQuery(nodeResponse.getUuid()), new ParameterProvider[0]).blockingGet();
        Assert.assertEquals((long)1L, (long)searchResponse.getData().size());
        Assert.assertEquals((Object)nodeResponse.getUuid(), (Object)((NodeResponse)searchResponse.getData().get(0)).getUuid());
    }

    @Test
    public void testSearchSchema() throws Exception {
        try (Tx tx = this.tx();){
            this.recreateIndices();
        }
        SchemaListResponse response = (SchemaListResponse)this.client().searchSchemas(MeshTestHelper.getSimpleQuery("name", "folder"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L))}).blockingGet();
        Assert.assertEquals((long)1L, (long)response.getData().size());
        response = (SchemaListResponse)this.client().searchSchemas(MeshTestHelper.getSimpleQuery("name", "blub"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L))}).blockingGet();
        Assert.assertEquals((long)0L, (long)response.getData().size());
        response = (SchemaListResponse)this.client().searchSchemas(MeshTestHelper.getSimpleTermQuery("name.raw", "folder"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L))}).blockingGet();
        Assert.assertEquals((long)1L, (long)response.getData().size());
    }

    @Override
    @Test
    public void testDocumentCreation() throws Exception {
        String newName = "newschema";
        SchemaResponse schema = this.createSchema("newschema");
        try (Tx tx = this.tx();){
            Assert.assertNotNull((Object)tx.schemaDao().findByUuid(schema.getUuid()));
        }
        this.waitForSearchIdleEvent();
        SchemaListResponse response = (SchemaListResponse)this.client().searchSchemas(MeshTestHelper.getSimpleTermQuery("name.raw", "newschema"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L))}).blockingGet();
        Assert.assertEquals((long)1L, (long)response.getData().size());
    }

    @Override
    @Test
    public void testDocumentDeletion() throws InterruptedException, JSONException {
        String schemaName = "newschemaname";
        SchemaResponse schema = this.createSchema("newschemaname");
        this.waitForSearchIdleEvent();
        SchemaListResponse response = (SchemaListResponse)this.client().searchSchemas(MeshTestHelper.getSimpleTermQuery("name.raw", "newschemaname"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L))}).blockingGet();
        Assert.assertEquals((long)1L, (long)response.getData().size());
        this.deleteSchema(schema.getUuid());
        response = (SchemaListResponse)this.client().searchSchemas(MeshTestHelper.getSimpleTermQuery("name.raw", "newschemaname"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L))}).blockingGet();
        Assert.assertEquals((long)0L, (long)response.getData().size());
    }

    @Override
    @Test
    @Ignore
    public void testDocumentUpdate() throws Exception {
        String schemaName = "newschemaname";
        SchemaResponse schema = this.createSchema("newschemaname");
        this.waitForSearchIdleEvent();
        String newSchemaName = "updatedschemaname";
        this.waitForLatestJob(() -> this.updateSchema(schema.getUuid(), newSchemaName, new SchemaUpdateParameters[0]));
        this.waitForSearchIdleEvent();
        SchemaListResponse response = (SchemaListResponse)this.client().searchSchemas(MeshTestHelper.getSimpleTermQuery("name", "newschemaname"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L))}).blockingGet();
        Assert.assertEquals((String)"The schema with the old name {newschemaname} was found but it should not have been since we updated it.", (long)0L, (long)response.getData().size());
        response = (SchemaListResponse)this.client().searchSchemas(MeshTestHelper.getSimpleTermQuery("name", newSchemaName), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L))}).blockingGet();
        Assert.assertEquals((String)"The schema with the updated name was not found.", (long)1L, (long)response.getData().size());
    }
}

