/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.core.rest.tag.TagFamilyListResponse;
import com.gentics.mesh.core.rest.tag.TagFamilyResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.search.AbstractMultiESTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.test.definition.BasicSearchCrudTestcases;
import org.codehaus.jettison.json.JSONException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(startServer=true, testSize=TestSize.FULL)
public class TagFamilySearchEndpointTest
extends AbstractMultiESTest
implements BasicSearchCrudTestcases {
    public TagFamilySearchEndpointTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Override
    @Test
    public void testDocumentCreation() throws InterruptedException, JSONException {
        String tagFamilyName = "newtagfamily";
        this.createTagFamily("dummy", tagFamilyName);
        this.waitForSearchIdleEvent();
        TagFamilyListResponse list = (TagFamilyListResponse)ClientHelper.call(() -> this.client().searchTagFamilies(MeshTestHelper.getSimpleTermQuery("name.raw", tagFamilyName), new ParameterProvider[0]));
        Assert.assertEquals((long)1L, (long)list.getData().size());
    }

    @Override
    @Test
    public void testDocumentDeletion() throws InterruptedException, JSONException {
        String tagFamilyName = "newtagfamily";
        TagFamilyResponse tagFamilyResponse = this.createTagFamily("dummy", tagFamilyName);
        this.waitForSearchIdleEvent();
        TagFamilyListResponse list = (TagFamilyListResponse)ClientHelper.call(() -> this.client().searchTagFamilies(MeshTestHelper.getSimpleTermQuery("name.raw", tagFamilyName), new ParameterProvider[0]));
        Assert.assertEquals((long)1L, (long)list.getData().size());
        this.deleteTagFamily("dummy", tagFamilyResponse.getUuid());
        this.waitForSearchIdleEvent();
        list = (TagFamilyListResponse)ClientHelper.call(() -> this.client().searchTagFamilies(MeshTestHelper.getSimpleTermQuery("name.raw", tagFamilyName), new ParameterProvider[0]));
        Assert.assertEquals((long)0L, (long)list.getData().size());
    }

    @Override
    @Test
    public void testDocumentUpdate() throws InterruptedException, JSONException {
        String tagFamilyName = "newtagfamily";
        TagFamilyResponse tagFamily = this.createTagFamily("dummy", tagFamilyName);
        String newTagFamilyName = "updatetagfamilyname";
        this.updateTagFamily("dummy", tagFamily.getUuid(), newTagFamilyName);
        this.waitForSearchIdleEvent();
        TagFamilyListResponse list = (TagFamilyListResponse)ClientHelper.call(() -> this.client().searchTagFamilies(MeshTestHelper.getSimpleTermQuery("name.raw", newTagFamilyName), new ParameterProvider[0]));
        Assert.assertEquals((String)("The simple term query for name {" + newTagFamilyName + "} did not find the updated tag family entry"), (long)1L, (long)list.getData().size());
        list = (TagFamilyListResponse)ClientHelper.call(() -> this.client().searchTagFamilies(MeshTestHelper.getSimpleTermQuery("name.raw", tagFamilyName), new ParameterProvider[0]));
        Assert.assertEquals((String)("The simple term query for name {" + tagFamilyName + "}did find tag families using the old name. Those documents should have been removed from the search index since we updated the tag family name."), (long)0L, (long)list.getData().size());
    }
}

