/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.tag.TagListResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.search.AbstractMultiESTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.test.definition.BasicSearchCrudTestcases;
import org.codehaus.jettison.json.JSONException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(startServer=true, testSize=TestSize.FULL)
public class TagSearchEndpointTest
extends AbstractMultiESTest
implements BasicSearchCrudTestcases {
    public TagSearchEndpointTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Override
    @Test
    public void testDocumentCreation() throws InterruptedException, JSONException {
        String tagName = "newtag";
        try (Tx tx = this.tx();){
            this.createTag("dummy", this.tagFamily("colors").getUuid(), tagName);
        }
        this.waitForSearchIdleEvent();
        TagListResponse list = (TagListResponse)ClientHelper.call(() -> this.client().searchTags(MeshTestHelper.getSimpleTermQuery("name.raw", tagName), new ParameterProvider[0]));
        Assert.assertEquals((long)1L, (long)list.getData().size());
    }

    @Override
    @Test
    public void testDocumentUpdate() throws InterruptedException, JSONException {
        String uuid = (String)this.tx(() -> this.tag("red").getUuid());
        String parentTagFamilyUuid = (String)this.tx(() -> this.tagFamily("colors").getUuid());
        String newName = "redish";
        this.updateTag("dummy", parentTagFamilyUuid, uuid, newName);
        this.updateTag("dummy", parentTagFamilyUuid, uuid, newName + "2");
        try (Tx tx = this.tx();){
            Assert.assertEquals((String)"The tag name was not updated as expected.", (Object)(newName + "2"), (Object)this.tag("red").getName());
        }
        this.waitForSearchIdleEvent();
        TagListResponse list = (TagListResponse)ClientHelper.call(() -> this.client().searchTags(MeshTestHelper.getSimpleTermQuery("name.raw", newName + "2"), new ParameterProvider[0]));
        Assert.assertEquals((long)1L, (long)list.getData().size());
    }

    @Override
    @Test
    public void testDocumentDeletion() throws Exception {
        try (Tx tx = this.tx();){
            this.recreateIndices();
        }
        String name = (String)this.tx(() -> this.tag("red").getName());
        String uuid = (String)this.tx(() -> this.tag("red").getUuid());
        String parentTagFamilyUuid = (String)this.tx(() -> this.tagFamily("colors").getUuid());
        this.waitForSearchIdleEvent();
        TagListResponse list = (TagListResponse)ClientHelper.call(() -> this.client().searchTags(MeshTestHelper.getSimpleTermQuery("name.raw", name), new ParameterProvider[0]));
        Assert.assertEquals((String)("The tag with name {" + name + "} and uuid {" + uuid + "} could not be found in the search index."), (long)1L, (long)list.getData().size());
        ClientHelper.call(() -> this.client().deleteTag("dummy", parentTagFamilyUuid, uuid));
        this.waitForSearchIdleEvent();
        list = (TagListResponse)ClientHelper.call(() -> this.client().searchTags(MeshTestHelper.getSimpleTermQuery("fields.name", name), new ParameterProvider[0]));
        Assert.assertEquals((long)0L, (long)list.getData().size());
    }
}

