/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.core.rest.group.GroupResponse;
import com.gentics.mesh.core.rest.user.UserCreateRequest;
import com.gentics.mesh.core.rest.user.UserListResponse;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.core.rest.user.UserUpdateRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.search.AbstractMultiESTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.test.definition.BasicSearchCrudTestcases;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import org.codehaus.jettison.json.JSONException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class UserSearchEndpointTest
extends AbstractMultiESTest
implements BasicSearchCrudTestcases {
    public UserSearchEndpointTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Test
    public void testSimpleQuerySearch() throws IOException {
        String username = "testuser42a";
        this.createUser(username);
        this.waitForSearchIdleEvent();
        String json = this.getESText("userWildcard.es");
        UserListResponse list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(json, new ParameterProvider[0]));
        Assert.assertEquals((long)1L, (long)list.getData().size());
        Assert.assertEquals((String)"The found element is not the user we were looking for", (Object)username, (Object)((UserResponse)list.getData().get(0)).getUsername());
    }

    @Test
    public void testSearchWithUTF8() throws IOException {
        String TEST_CN = "\u6d4b\u8bd5";
        String LONG_DASH = "\u2013";
        String name = "testuser_" + TEST_CN + "_" + LONG_DASH + "_" + TEST_CN;
        this.createUser(name);
        this.waitForSearchIdleEvent();
        String json = this.getESText("userWildcard.es");
        UserListResponse list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The page should be full.", (long)1L, (long)list.getData().size());
        Assert.assertEquals((String)"The page did not match.", (long)1L, (long)list.getMetainfo().getCurrentPage());
        Assert.assertEquals((String)"The page count did not match.", (long)1L, (long)list.getMetainfo().getPageCount());
        Assert.assertEquals((String)"The total count did not match.", (long)1L, (long)list.getMetainfo().getTotalCount());
    }

    @Test
    public void testPaging() throws IOException {
        String username = "testuser";
        for (int i = 0; i < 100; ++i) {
            this.createUser(username + i);
        }
        this.waitForSearchIdleEvent();
        String json = this.getESText("userWildcard.es");
        UserListResponse list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(json, new ParameterProvider[]{new PagingParametersImpl(2, Long.valueOf(25L))}));
        Assert.assertEquals((String)"The page should be full.", (long)25L, (long)list.getData().size());
        Assert.assertEquals((String)"The page did not match.", (long)2L, (long)list.getMetainfo().getCurrentPage());
        Assert.assertEquals((String)"The page count did not match.", (long)4L, (long)list.getMetainfo().getPageCount());
        Assert.assertEquals((String)"The total count did not match.", (long)100L, (long)list.getMetainfo().getTotalCount());
    }

    @Test
    public void testPagingWithoutPagingParameters() throws IOException {
        String username = "testuser";
        for (int i = 0; i < 20; ++i) {
            this.createUser(username + i);
        }
        this.waitForSearchIdleEvent();
        String json = this.getESText("userWildcard.es");
        UserListResponse list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The page should be full.", (long)10L, (long)list.getData().size());
        Assert.assertEquals((String)"The page did not match.", (long)1L, (long)list.getMetainfo().getCurrentPage());
        Assert.assertEquals((String)"The page count did not match.", (long)2L, (long)list.getMetainfo().getPageCount());
        Assert.assertEquals((String)"The total count did not match.", (long)20L, (long)list.getMetainfo().getTotalCount());
    }

    @Test
    public void testBogusQuery() throws IOException {
        String username = "testuser42a";
        this.createUser(username);
        this.waitForSearchIdleEvent();
        String json = "someBogusInput";
        ClientHelper.call(() -> this.client().searchUsers(json, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"search_query_not_parsable", (String[])new String[0]);
    }

    @Test
    public void testEmptyResult() throws IOException {
        String username = "testuser42a";
        this.createUser(username);
        this.waitForSearchIdleEvent();
        String json = this.getESText("userBogusName.es");
        UserListResponse list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(json, new ParameterProvider[0]));
        Assert.assertEquals((long)0L, (long)list.getData().size());
    }

    @Override
    @Test
    public void testDocumentCreation() throws InterruptedException, JSONException {
        String username = "testuser42a";
        this.createUser(username);
        this.waitForSearchIdleEvent();
        UserListResponse list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(MeshTestHelper.getSimpleTermQuery("username.raw", username), new ParameterProvider[0]));
        Assert.assertEquals((long)1L, (long)list.getData().size());
    }

    @Test
    public void testTokenzierIssueQuery() throws Exception {
        String impossibleName = "J\u00f6h\u00e4@sRe2";
        UserUpdateRequest updateRequest = new UserUpdateRequest();
        updateRequest.setLastname(impossibleName);
        ClientHelper.call(() -> this.client().updateUser(this.userUuid(), updateRequest, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        UserListResponse list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(MeshTestHelper.getSimpleTermQuery("lastname.raw", impossibleName), new ParameterProvider[0]));
        Assert.assertNotNull((Object)list);
        Assert.assertFalse((String)("The user with the name {" + impossibleName + "} could not be found using a simple term query."), (boolean)list.getData().isEmpty());
        Assert.assertEquals((long)1L, (long)list.getData().size());
        Assert.assertEquals((Object)impossibleName, (Object)((UserResponse)list.getData().get(0)).getLastname());
    }

    @Test
    public void testTokenzierIssueQuery2() throws Exception {
        String impossibleName = "J\u00f6h\u00e4@sRe";
        UserUpdateRequest updateRequest = new UserUpdateRequest();
        updateRequest.setLastname(impossibleName);
        ClientHelper.call(() -> this.client().updateUser(this.userUuid(), updateRequest, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        UserListResponse list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(MeshTestHelper.getSimpleWildCardQuery("lastname.raw", "*" + impossibleName + "*"), new ParameterProvider[0]));
        Assert.assertNotNull((Object)list);
        Assert.assertFalse((boolean)list.getData().isEmpty());
        Assert.assertEquals((long)1L, (long)list.getData().size());
        Assert.assertEquals((Object)impossibleName, (Object)((UserResponse)list.getData().get(0)).getLastname());
    }

    @Test
    public void testTokenzierIssueLowercasedQuery() throws Exception {
        String impossibleName = "J\u00f6h\u00e4@sRe";
        UserUpdateRequest updateRequest = new UserUpdateRequest();
        updateRequest.setLastname(impossibleName);
        ClientHelper.call(() -> this.client().updateUser(this.userUuid(), updateRequest, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        UserListResponse list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(MeshTestHelper.getSimpleWildCardQuery("lastname.raw", "*" + impossibleName.toLowerCase() + "*"), new ParameterProvider[0]));
        Assert.assertNotNull((Object)list);
        Assert.assertTrue((String)"No user should be found since the lastname field is not tokenized anymore thus it is not possible to search with a lowercased term.", (boolean)list.getData().isEmpty());
    }

    @Test
    public void testSearchForUserByEmail() throws Exception {
        this.recreateIndices();
        String email = "testmail@test.com";
        UserCreateRequest request = new UserCreateRequest();
        request.setUsername("testuser42a");
        request.setPassword("test1234");
        request.setEmailAddress(email);
        request.setGroupUuid((String)this.tx(() -> this.group().getUuid()));
        ClientHelper.call(() -> this.client().createUser(request, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        UserListResponse list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(MeshTestHelper.getSimpleWildCardQuery("emailaddress", "*"), new ParameterProvider[0]));
        Assert.assertEquals((String)"We expected to see two results.", (long)2L, (long)list.getData().size());
    }

    @Test
    public void testSearchUserForGroup() throws Exception {
        this.recreateIndices();
        String username = "extrauser42a";
        String groupName = (String)this.tx(() -> this.group().getName());
        this.createUser(username);
        this.waitForSearchIdleEvent();
        UserListResponse list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(MeshTestHelper.getSimpleTermQuery("groups.name.raw", groupName.toLowerCase()), new ParameterProvider[0]));
        Assert.assertEquals((String)"We expected to see two results.", (long)2L, (long)list.getData().size());
    }

    @Test
    public void testSearchForAddedUser() throws InterruptedException, JSONException {
        GroupResponse group = this.createGroup("apa");
        String groupName = group.getName();
        String username = "extrauser42a";
        UserCreateRequest request = new UserCreateRequest();
        request.setUsername(username);
        request.setPassword("test1234");
        request.setGroupUuid(group.getUuid());
        ClientHelper.call(() -> this.client().createUser(request, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        UserListResponse searchResponse = (UserListResponse)this.client().searchUsers(MeshTestHelper.getSimpleTermQuery("groups.name.raw", groupName.toLowerCase()), new ParameterProvider[0]).blockingGet();
        Assert.assertEquals((String)"We expected to see one result.", (long)1L, (long)searchResponse.getData().size());
    }

    @Test
    public void testSearchForLaterAddedUser() throws InterruptedException, JSONException {
        GroupResponse group = this.createGroup("apaotsadmin");
        String groupName = group.getName();
        String username = "extrauser42a";
        UserCreateRequest request = new UserCreateRequest();
        request.setUsername(username);
        request.setPassword("test1234");
        UserResponse user = (UserResponse)ClientHelper.call(() -> this.client().createUser(request, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().addUserToGroup(group.getUuid(), user.getUuid()));
        this.waitForSearchIdleEvent();
        UserListResponse response = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(MeshTestHelper.getSimpleTermQuery("groups.name.raw", groupName.toLowerCase()), new ParameterProvider[0]));
        System.out.println(response.toJson());
        Assert.assertEquals((String)"We assigned the user to the group and thus the index should have been updated but we were unable to find the user with the specified group.", (long)1L, (long)response.getData().size());
    }

    @Test
    public void testSearchForRemovedUser() throws InterruptedException, JSONException {
        GroupResponse group = this.createGroup("apa-otsAdmin");
        String groupName = group.getName();
        String username = "extrauser42a";
        UserCreateRequest request = new UserCreateRequest();
        request.setUsername(username);
        request.setPassword("test1234");
        request.setGroupUuid(group.getUuid());
        UserResponse response = (UserResponse)ClientHelper.call(() -> this.client().createUser(request, new ParameterProvider[0]));
        String userUuid = response.getUuid();
        ClientHelper.call(() -> this.client().removeUserFromGroup(group.getUuid(), userUuid));
        this.waitForSearchIdleEvent();
        UserListResponse list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(MeshTestHelper.getSimpleTermQuery("groups.name.raw", groupName.toLowerCase()), new ParameterProvider[0]));
        Assert.assertEquals((long)0L, (long)list.getData().size());
    }

    @Test
    public void testSearchForDeletedUser() throws InterruptedException, JSONException {
        GroupResponse group = this.createGroup("apa-otsAdmin");
        String groupName = group.getName();
        String username = "extrauser42a";
        UserCreateRequest request = new UserCreateRequest();
        request.setUsername(username);
        request.setPassword("test1234");
        request.setGroupUuid(group.getUuid());
        UserResponse user = (UserResponse)ClientHelper.call(() -> this.client().createUser(request, new ParameterProvider[0]));
        String userUuid = user.getUuid();
        ClientHelper.call(() -> this.client().deleteUser(userUuid));
        this.waitForSearchIdleEvent();
        UserListResponse list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(MeshTestHelper.getSimpleTermQuery("groups.name.raw", groupName.toLowerCase()), new ParameterProvider[0]));
        Assert.assertEquals((long)0L, (long)list.getData().size());
    }

    @Test
    public void testSearchUserWithPerPageZero() throws Exception {
        this.recreateIndices();
        String groupName = (String)this.tx(() -> this.group().getName());
        String username = "extrauser42a";
        this.createUser(username);
        this.waitForSearchIdleEvent();
        UserListResponse list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(MeshTestHelper.getSimpleTermQuery("groups.name.raw", groupName.toLowerCase()), new ParameterProvider[]{new PagingParametersImpl().setPerPage(Long.valueOf(0L))}));
        Assert.assertEquals((long)0L, (long)list.getData().size());
        Assert.assertEquals((long)2L, (long)list.getMetainfo().getTotalCount());
    }

    @Override
    @Test
    public void testDocumentDeletion() throws InterruptedException, JSONException {
        String userName = "testuser42a";
        UserResponse user = this.createUser(userName);
        ClientHelper.call(() -> this.client().deleteUser(user.getUuid()));
        this.waitForSearchIdleEvent();
        UserListResponse list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(MeshTestHelper.getSimpleTermQuery("username", userName), new ParameterProvider[0]));
        Assert.assertEquals((long)0L, (long)list.getData().size());
    }

    @Override
    @Test
    public void testDocumentUpdate() throws InterruptedException, JSONException {
        String userName = "testuser42a";
        String newUserName = "testgrouprenamed";
        UserResponse user = this.createUser(userName);
        user = this.updateUser(user.getUuid(), newUserName);
        this.waitForSearchIdleEvent();
        UserListResponse list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(MeshTestHelper.getSimpleTermQuery("username.raw", userName), new ParameterProvider[0]));
        Assert.assertEquals((long)0L, (long)list.getData().size());
        list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(MeshTestHelper.getSimpleTermQuery("username.raw", newUserName), new ParameterProvider[0]));
        Assert.assertEquals((long)1L, (long)list.getData().size());
    }
}

