/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.etc.config.search.ComplianceMode;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.SearchParametersImpl;
import com.gentics.mesh.search.AbstractMultiESTest;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.MeshTestHelper;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.FULL, startServer=true)
public class WaitSearchEndpointTest
extends AbstractMultiESTest {
    public WaitSearchEndpointTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Before
    public void setUp() throws Exception {
        this.createNode("slug", (Field)new StringFieldImpl().setString("waittest"));
    }

    private NodeListResponse search(boolean wait) {
        return (NodeListResponse)this.client().searchNodes(MeshTestHelper.getSimpleQuery("fields.slug", "waittest"), new ParameterProvider[]{new SearchParametersImpl().setWait(wait)}).blockingGet();
    }

    private ObjectNode rawSearch(boolean wait) {
        return (ObjectNode)this.client().searchNodesRaw(MeshTestHelper.getSimpleQuery("fields.slug", "waittest"), new ParameterProvider[]{new SearchParametersImpl().setWait(wait)}).blockingGet();
    }

    @Test
    public void searchWithWaitDisabled() {
        NodeListResponse result = this.search(false);
        Assertions.assertThat((long)result.getMetainfo().getTotalCount()).isEqualTo(0L);
    }

    @Test
    public void searchWithWaitEnabled() {
        NodeListResponse result = this.search(true);
        Assertions.assertThat((long)result.getMetainfo().getTotalCount()).isEqualTo(1L);
    }

    @Test
    public void rawSearchWithWaitDisabled() {
        ObjectNode result = this.rawSearch(false);
        if (this.complianceMode() == ComplianceMode.ES_7) {
            Assertions.assertThat((long)result.get("responses").get(0).get("hits").get("total").get("value").asLong()).isEqualTo(0L);
        } else {
            Assertions.assertThat((long)result.get("responses").get(0).get("hits").get("total").asLong()).isEqualTo(0L);
        }
    }

    @Test
    public void rawSearchWithWaitEnabled() {
        ObjectNode result = this.rawSearch(true);
        if (this.complianceMode() == ComplianceMode.ES_7) {
            Assertions.assertThat((long)result.get("responses").get(0).get("hits").get("total").get("value").asLong()).isEqualTo(1L);
        } else {
            Assertions.assertThat((long)result.get("responses").get(0).get("hits").get("total").asLong()).isEqualTo(1L);
        }
    }
}

