/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.index;

import com.gentics.elasticsearch.client.ElasticsearchClient;
import com.gentics.elasticsearch.client.HttpErrorException;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.context.impl.BulkActionContextImpl;
import com.gentics.mesh.context.impl.DummyBulkActionContext;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.PersistingMicroschemaDao;
import com.gentics.mesh.core.data.dao.PersistingSchemaDao;
import com.gentics.mesh.core.data.dao.PersistingTagFamilyDao;
import com.gentics.mesh.core.data.dao.PersistingUserDao;
import com.gentics.mesh.core.data.dao.SchemaDao;
import com.gentics.mesh.core.data.dao.TagDao;
import com.gentics.mesh.core.data.group.HibGroup;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.role.HibRole;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.data.tag.HibTag;
import com.gentics.mesh.core.data.tagfamily.HibTagFamily;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.AbstractResponse;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.common.GenericMessageResponse;
import com.gentics.mesh.core.rest.microschema.MicroschemaVersionModel;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaModelImpl;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.project.ProjectCreateRequest;
import com.gentics.mesh.core.rest.project.ProjectListResponse;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaModelImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.search.EntityMetrics;
import com.gentics.mesh.core.rest.search.SearchStatusResponse;
import com.gentics.mesh.core.rest.user.UserListResponse;
import com.gentics.mesh.event.EventQueueBatch;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.helper.ExpectedEvent;
import com.gentics.mesh.test.helper.UnexpectedEvent;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Flowable;
import io.vertx.core.json.JsonObject;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.FULL, startServer=true)
public class BasicIndexSyncTest
extends AbstractMeshTest {
    @Before
    public void setup() throws Exception {
        this.getProvider().clear().blockingAwait();
        this.syncIndex();
    }

    @Test
    @Ignore(value="Fails on CI pipeline. See https://github.com/gentics/mesh/issues/608")
    public void testIndexSyncLock() throws Exception {
        this.grantAdmin();
        this.tx(tx -> {
            for (int i = 0; i < 900; ++i) {
                tx.groupDao().create("group_" + i, this.user(), null);
            }
        });
        this.waitForEvent(MeshEvent.INDEX_SYNC_FINISHED, () -> {
            ClientHelper.call(() -> this.client().invokeIndexSync(new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().invokeIndexSync(new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.SERVICE_UNAVAILABLE, (String)"search_admin_index_sync_already_in_progress", (String[])new String[0]);
        });
    }

    @Test
    public void testNoPermSync() {
        this.revokeAdmin();
        ClientHelper.call(() -> this.client().invokeIndexSync(new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_admin_permission_required", (String[])new String[0]);
    }

    @Test
    public void testResync() throws Exception {
        this.grantAdmin();
        this.searchProvider().refreshIndex(new String[0]).blockingAwait();
        this.waitForEvent(MeshEvent.INDEX_SYNC_FINISHED, () -> {
            GenericMessageResponse message = (GenericMessageResponse)ClientHelper.call(() -> this.client().invokeIndexSync(new ParameterProvider[0]));
            MeshAssertions.assertThat((GenericMessageResponse)message).matches("search_admin_index_sync_invoked", new String[0]);
        });
    }

    @Test
    @Ignore(value="Currently fails due to https://github.com/gentics/mesh/issues/606")
    public void testUserSync() throws Exception {
        this.tx(tx -> {
            for (int i = 0; i < 400; ++i) {
                tx.userDao().create("user_" + i, this.user(), null);
            }
        });
        this.syncIndex();
        this.assertMetrics("user", 400L, 0L, 0L);
        this.tx(() -> this.user().setUsername("updated"));
        this.syncIndex();
        this.assertMetrics("user", 0L, 1L, 0L);
        this.tx(tx -> {
            PersistingUserDao userDao = ((CommonTx)tx).userDao();
            userDao.deletePersisted((HibBaseElement)((HibUser)userDao.findByName("user_3")));
        });
        this.syncIndex();
        this.assertMetrics("user", 0L, 0L, 1L);
    }

    @Test
    public void testGroupSync() throws Exception {
        this.tx(tx -> {
            for (int i = 0; i < 400; ++i) {
                tx.groupDao().create("group_" + i, this.user(), null);
            }
        });
        this.syncIndex();
        this.assertMetrics("group", 400L, 0L, 0L);
        this.tx(() -> ((HibGroup)Tx.get().groupDao().findByUuid(this.group().getUuid())).setName("updated"));
        this.syncIndex();
        this.assertMetrics("group", 0L, 1L, 0L);
        this.tx(tx -> {
            HibGroup group3 = (HibGroup)tx.groupDao().findByName("group_3");
            CommonTx.get().groupDao().deletePersisted((HibBaseElement)group3);
        });
        this.syncIndex();
        this.assertMetrics("group", 0L, 0L, 1L);
    }

    @Test
    public void testRoleSync() throws Exception {
        this.tx(tx -> {
            for (int i = 0; i < 400; ++i) {
                tx.roleDao().create("role_" + i, this.user(), null);
            }
        });
        this.syncIndex();
        this.assertMetrics("role", 400L, 0L, 0L);
        this.tx(tx -> ((HibRole)tx.roleDao().findByUuid(this.role().getUuid())).setName("updated"));
        this.syncIndex();
        this.assertMetrics("role", 0L, 1L, 0L);
        this.tx(tx -> ((HibRole)tx.roleDao().findByName("role_3")).removeElement());
        this.syncIndex();
        this.assertMetrics("role", 0L, 0L, 1L);
    }

    @Test
    @Ignore(value="Currently fails due to https://github.com/gentics/mesh/issues/606")
    public void testTagSync() throws Exception {
        TagDao tagDao = Tx.get().tagDao();
        this.tx(tx -> {
            for (int i = 0; i < 400; ++i) {
                tagDao.create(this.tagFamily("colors"), "tag_" + i, this.project(), this.user());
            }
        });
        this.syncIndex();
        this.assertMetrics("tag", 400L, 3L, 0L);
        this.tx(tx -> ((HibTag)tx.tagDao().findByUuid(this.tag("red").getUuid())).setName("updated"));
        this.syncIndex();
        this.assertMetrics("tag", 0L, 1L, 0L);
        this.tx(tx -> {
            HibTagFamily tagFamily = this.tagFamily("colors");
            HibTag tag = (HibTag)tagDao.findByName((HibCoreElement)tagFamily, "tag_3");
            ((CommonTx)tx.unwrap()).tagDao().deletePersisted((HibBaseElement)tag);
        });
        this.syncIndex();
        this.assertMetrics("tag", 0L, 0L, 1L);
    }

    @Test
    public void testTagFamilySync() throws Exception {
        this.tx(tx -> {
            CommonTx ctx = (CommonTx)tx.unwrap();
            HibProject project = (HibProject)Tx.get().projectDao().findByUuid(this.projectUuid());
            HibUser user = (HibUser)Tx.get().userDao().findByUuid(this.userUuid());
            for (int i = 0; i < 400; ++i) {
                ctx.tagFamilyDao().create(project, "tagfamily_" + i, user);
            }
        });
        this.syncIndex();
        this.assertMetrics("tagfamily", 400L, 0L, 0L);
        this.syncIndex();
        this.assertMetrics("tagfamily", 0L, 0L, 0L);
        this.tx(tx -> ((HibTagFamily)tx.tagFamilyDao().findByUuid(this.tagFamily("colors").getUuid())).setName("updated"));
        this.syncIndex();
        this.assertMetrics("tagfamily", 0L, 1L, 0L);
        this.tx(tx -> {
            PersistingTagFamilyDao tagFamilyDao = ((CommonTx)Tx.get().unwrap()).tagFamilyDao();
            HibTagFamily tagfamily_3 = (HibTagFamily)tagFamilyDao.findByName((HibCoreElement)this.project(), "tagfamily_3");
            tagFamilyDao.deletePersisted((HibCoreElement)this.project(), (HibCoreElement)tagfamily_3);
        });
        this.syncIndex();
        this.assertMetrics("tagfamily", 0L, 0L, 1L);
    }

    @Test
    public void testProjectSync() throws Exception {
        int i = 0;
        while (i < 3) {
            int e = i++;
            ClientHelper.call(() -> this.client().createProject(new ProjectCreateRequest().setName("project_" + e).setSchemaRef("folder")));
        }
        this.waitForSearchIdleEvent();
        this.getProvider().clear().blockingAwait();
        this.syncIndex();
        this.assertMetrics("project", 4L, 0L, 0L);
        this.syncIndex();
        this.assertMetrics("project", 0L, 0L, 0L);
        this.tx(tx -> ((HibProject)tx.projectDao().findByUuid(this.project().getUuid())).setName("updated"));
        this.boot().globalCacheClear();
        this.syncIndex();
        this.assertMetrics("project", 0L, 1L, 0L);
        this.tx(tx -> {
            HibProject project = (HibProject)tx.projectDao().findByName("project_2");
            BulkActionContextImpl context = (BulkActionContextImpl)Mockito.mock(BulkActionContextImpl.class);
            Mockito.when((Object)context.batch()).thenReturn((Object)((EventQueueBatch)Mockito.mock(EventQueueBatch.class)));
            tx.projectDao().delete((HibBaseElement)project, (BulkActionContext)context);
        });
        this.boot().globalCacheClear();
        this.syncIndex();
        this.assertMetrics("project", 0L, 0L, 1L);
    }

    @Test
    public void testNodeSync() throws Exception {
        this.tx(tx -> {
            HibNode node = this.folder("2015");
            tx.contentDao().createFieldContainer(node, this.german(), this.initialBranch(), this.user());
        });
        this.syncIndex();
        this.assertInsertedMetrics((EntityMetrics)((SearchStatusResponse)ClientHelper.call(() -> this.client().searchStatus())).getMetrics().get("node"), 1L);
        this.syncIndex();
        this.assertMetrics("node", 0L, 0L, 0L);
        this.tx(tx -> {
            NodeUpdateRequest updateRequest = new NodeUpdateRequest();
            updateRequest.setFields(FieldMap.of((String)"slug", (Field)new StringFieldImpl().setString("updated")));
            updateRequest.setLanguage("en");
            ClientHelper.call(() -> this.client().updateNode(this.folder("2015").getProject().getName(), this.contentUuid(), updateRequest, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"en"})}));
        });
        this.syncIndex();
        EntityMetrics metrics = (EntityMetrics)((SearchStatusResponse)ClientHelper.call(() -> this.client().searchStatus())).getMetrics().get("node");
        MeshAssertions.assertThat((Long)metrics.getUpdate().getSynced()).isGreaterThanOrEqualTo(1L);
        MeshAssertions.assertThat((Long)metrics.getUpdate().getPending()).isEqualTo(0L);
        this.tx(tx -> {
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer draft = contentDao.getFieldContainer(this.folder("2015"), this.german(), this.latestBranch(), ContainerType.DRAFT);
            contentDao.delete(draft, (BulkActionContext)new DummyBulkActionContext());
        });
        this.syncIndex();
        this.assertDeletedMetrics((EntityMetrics)((SearchStatusResponse)ClientHelper.call(() -> this.client().searchStatus())).getMetrics().get("node"), 1L);
    }

    @Test
    public void testSchemaSync() throws Exception {
        this.tx(tx -> {
            SchemaDao schemaDao = tx.schemaDao();
            for (int i = 0; i < 400; ++i) {
                SchemaModelImpl model = new SchemaModelImpl();
                model.setName("schema_" + i);
                schemaDao.create((SchemaVersionModel)model, this.user());
            }
        });
        this.syncIndex();
        this.assertMetrics("schema", 400L, 0L, 0L);
        SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(new SchemaCreateRequest().setName("dummy"), new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        this.tx(tx -> ((HibSchema)tx.schemaDao().findByUuid(response.getUuid())).setName("updated"));
        this.syncIndex();
        this.assertMetrics("schema", 0L, 1L, 0L);
        this.tx(tx -> {
            PersistingSchemaDao schemaDao = ((CommonTx)tx).schemaDao();
            HibSchema schema = (HibSchema)schemaDao.findByName("schema_3");
            schemaDao.deleteVersion((HibFieldSchemaVersionElement)((HibSchemaVersion)schema.getLatestVersion()), (BulkActionContext)new DummyBulkActionContext());
            schemaDao.deletePersisted((HibBaseElement)schema);
        });
        this.syncIndex();
        this.assertMetrics("schema", 0L, 0L, 1L);
    }

    @Test
    public void testMicroschemaSync() throws Exception {
        this.tx(() -> {
            for (int i = 0; i < 400; ++i) {
                MicroschemaModelImpl model = new MicroschemaModelImpl();
                model.setName("microschema_" + i);
                this.createMicroschema((MicroschemaVersionModel)model);
            }
        });
        this.syncIndex();
        this.assertMetrics("microschema", 400L, 0L, 0L);
        this.tx(tx -> ((HibMicroschema)tx.microschemaDao().findByName("microschema_100")).setName("updated"));
        this.syncIndex();
        this.assertMetrics("microschema", 0L, 1L, 0L);
        this.tx(tx -> {
            PersistingMicroschemaDao microschemaDao = ((CommonTx)tx).microschemaDao();
            HibMicroschema microschema = (HibMicroschema)microschemaDao.findByName("microschema_101");
            microschemaDao.deleteVersion((HibFieldSchemaVersionElement)microschema.getLatestVersion(), (BulkActionContext)new DummyBulkActionContext());
            microschemaDao.deletePersisted((HibBaseElement)microschema);
        });
        this.syncIndex();
        this.assertMetrics("microschema", 0L, 0L, 1L);
    }

    @Test
    public void testIndexSyncCheckNoChange() throws Exception {
        int timeoutMs = 10000;
        this.grantAdmin();
        this.searchProvider().refreshIndex(new String[0]).blockingAwait();
        try (ExpectedEvent finished = this.expectEvent(MeshEvent.INDEX_CHECK_FINISHED, timeoutMs);
             UnexpectedEvent syncFinished = this.notExpectEvent(MeshEvent.INDEX_SYNC_FINISHED, timeoutMs);){
            this.vertx().eventBus().publish(MeshEvent.INDEX_CHECK_REQUEST.address, null);
        }
    }

    @Test
    public void testAutoIndexRecreation() throws Exception {
        JsonObject mappings;
        Set projectUuids;
        ElasticsearchClient client;
        String esIndexName;
        int timeoutMs;
        block14: {
            timeoutMs = 10000;
            String meshIndexName = "project";
            esIndexName = this.options().getSearchOptions().getPrefix() + meshIndexName;
            client = (ElasticsearchClient)this.searchProvider().getClient();
            this.grantAdmin();
            this.searchProvider().refreshIndex(new String[0]).blockingAwait();
            projectUuids = ((ProjectListResponse)ClientHelper.call(() -> this.client().findProjects(new ParameterProvider[0]))).getData().stream().map(AbstractResponse::getUuid).collect(Collectors.toSet());
            MeshAssertions.assertThat(projectUuids).isNotEmpty();
            mappings = this.getIndexMappings(esIndexName);
            client.deleteIndex(new String[]{esIndexName}).sync();
            try {
                client.readIndex(new String[]{esIndexName}).sync();
                Assertions.fail((String)("Index " + esIndexName + " should have been deleted"));
            }
            catch (HttpErrorException e) {
                if (e.statusCode == HttpResponseStatus.NOT_FOUND.code()) break block14;
                throw e;
            }
        }
        try (ExpectedEvent finished = this.expectEvent(MeshEvent.INDEX_CHECK_FINISHED, timeoutMs);
             ExpectedEvent syncFinished = this.expectEvent(MeshEvent.INDEX_SYNC_FINISHED, timeoutMs);){
            this.vertx().eventBus().publish(MeshEvent.INDEX_CHECK_REQUEST.address, null);
        }
        MeshAssertions.assertThat((JsonObject)this.getIndexMappings(esIndexName)).isEqualTo((Object)mappings);
        Flowable.fromIterable(projectUuids).flatMapSingle(uuid -> client.readDocument(esIndexName, uuid).async()).blockingSubscribe();
    }

    @Test
    public void testAutoIndexFix() throws Exception {
        ExpectedEvent syncFinished;
        int timeoutMs = 10000;
        String meshIndexName = "user";
        String esIndexName = this.options().getSearchOptions().getPrefix() + meshIndexName;
        ElasticsearchClient client = (ElasticsearchClient)this.searchProvider().getClient();
        this.grantAdmin();
        this.searchProvider().refreshIndex(new String[0]).blockingAwait();
        Set userUuids = ((UserListResponse)ClientHelper.call(() -> this.client().findUsers(new ParameterProvider[0]))).getData().stream().map(AbstractResponse::getUuid).collect(Collectors.toSet());
        MeshAssertions.assertThat(userUuids).isNotEmpty();
        JsonObject mappings = this.getIndexMappings(esIndexName);
        client.deleteIndex(new String[]{esIndexName}).sync();
        client.storeDocument(esIndexName, "dummy", (Object)new JsonObject("{\"name\": \"dummy\"}")).sync();
        MeshAssertions.assertThat((JsonObject)this.getIndexMappings(esIndexName)).isNotEqualTo((Object)mappings);
        try (ExpectedEvent finished = this.expectEvent(MeshEvent.INDEX_CHECK_FINISHED, timeoutMs);){
            syncFinished = this.expectEvent(MeshEvent.INDEX_SYNC_FINISHED, timeoutMs);
            try {
                this.vertx().eventBus().publish(MeshEvent.INDEX_CHECK_REQUEST.address, null);
            }
            finally {
                if (syncFinished != null) {
                    syncFinished.close();
                }
            }
        }
        MeshAssertions.assertThat((JsonObject)this.getIndexMappings(esIndexName)).isEqualTo((Object)mappings);
        Flowable.fromIterable(userUuids).flatMapSingle(uuid -> client.readDocument(esIndexName, uuid).async()).blockingSubscribe();
        finished = this.expectEvent(MeshEvent.INDEX_CHECK_FINISHED, timeoutMs);
        try {
            syncFinished = this.notExpectEvent(MeshEvent.INDEX_SYNC_FINISHED, timeoutMs);
            try {
                this.vertx().eventBus().publish(MeshEvent.INDEX_CHECK_REQUEST.address, null);
            }
            finally {
                if (syncFinished != null) {
                    syncFinished.close();
                }
            }
        }
        finally {
            if (finished != null) {
                finished.close();
            }
        }
    }

    private void assertMetrics(String type, long inserted, long updated, long deleted) {
        EntityMetrics entityMetrics = (EntityMetrics)((SearchStatusResponse)ClientHelper.call(() -> this.client().searchStatus())).getMetrics().get(type);
        this.assertInsertedMetrics(entityMetrics, inserted);
        this.assertUpdatedMetrics(entityMetrics, updated);
        this.assertDeletedMetrics(entityMetrics, deleted);
    }

    private void assertInsertedMetrics(EntityMetrics entityMetrics, long inserted) {
        Assert.assertEquals((String)("We expected " + inserted + " elements to be inserted during the sync"), (long)inserted, (long)entityMetrics.getInsert().getSynced());
        Assert.assertEquals((String)"Pending inserts should be zero after the sync.", (long)0L, (long)entityMetrics.getInsert().getPending());
    }

    private void assertUpdatedMetrics(EntityMetrics entityMetrics, long updated) {
        Assert.assertEquals((String)("We expected " + updated + " elements to be updated during the sync"), (long)updated, (long)entityMetrics.getUpdate().getSynced());
        Assert.assertEquals((String)"Pending updates should be zero after the sync.", (long)0L, (long)entityMetrics.getUpdate().getPending());
    }

    private void assertDeletedMetrics(EntityMetrics entityMetrics, long deleted) {
        Assert.assertEquals((String)("We expected " + deleted + " elements to be deleted during the sync"), (long)deleted, (long)entityMetrics.getDelete().getSynced());
        Assert.assertEquals((String)"Pending deletes should be zero after the sync.", (long)0L, (long)entityMetrics.getDelete().getPending());
    }
}

