/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.index;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.branch.BranchCreateRequest;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.SchemaUpdateParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.FULL, startServer=true)
public class BranchIndexSyncTest
extends AbstractMeshTest {
    @Test
    public void testSyncWithUnmigratedBranch() {
        this.waitForJob(() -> {
            BranchCreateRequest branchCreateRequest = new BranchCreateRequest();
            branchCreateRequest.setLatest(true);
            branchCreateRequest.setName("newBranch");
            ClientHelper.call(() -> this.client().createBranch(this.projectName(), branchCreateRequest, new ParameterProvider[0]));
        });
        String contentSchemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        SchemaUpdateRequest request = (SchemaUpdateRequest)JsonUtil.readValue((String)((String)this.tx(() -> ((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getJson())), SchemaUpdateRequest.class);
        request.removeField("teaser");
        request.addField((FieldSchema)FieldUtil.createNumberFieldSchema((String)"teaser"));
        ClientHelper.call(() -> this.client().updateSchema(contentSchemaUuid, request, new ParameterProvider[]{new SchemaUpdateParametersImpl().setUpdateAssignedBranches(false)}));
        this.waitForEvent(MeshEvent.INDEX_SYNC_FINISHED, () -> {
            ClientHelper.call(() -> this.client().invokeIndexClear(new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().invokeIndexSync(new ParameterProvider[0]));
        });
    }
}

