/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.index;

import com.gentics.mesh.core.data.Bucket;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.PersistingGroupDao;
import com.gentics.mesh.core.data.dao.PersistingUserDao;
import com.gentics.mesh.core.data.group.HibGroup;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.search.index.BucketManager;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.MathUtil;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class BucketManagerTest
extends AbstractMeshTest {
    @Test
    public void testSmallerBatchSizeVsElementCount() {
        int syncBatchSize = 10;
        this.options().getSearchOptions().setSyncBatchSize(syncBatchSize);
        try (Tx tx = this.tx();){
            int nUsers = 11;
            long total = this.createUsers(nUsers);
            BucketManager bulkManager = this.mesh().bucketManager();
            List buckets = (List)bulkManager.getBuckets(total).toList().blockingGet();
            this.assertBuckets(buckets, syncBatchSize);
            int expectedBucketCount = 2;
            Assert.assertEquals((long)expectedBucketCount, (long)buckets.size());
        }
    }

    @Test
    public void testBatchSizeZero() {
        int syncBatchSize = 0;
        this.options().getSearchOptions().setSyncBatchSize(syncBatchSize);
        try (Tx tx = this.tx();){
            int nUsers = 500;
            long total = this.createUsers(nUsers);
            BucketManager bulkManager = this.mesh().bucketManager();
            List buckets = (List)bulkManager.getBuckets(total).toList().blockingGet();
            this.assertBuckets(buckets, syncBatchSize);
            int expectedBucketCount = 1;
            Assert.assertEquals((long)expectedBucketCount, (long)buckets.size());
        }
    }

    @Test
    public void testManagerForNoElements() {
        int syncBatchSize = 100;
        this.options().getSearchOptions().setSyncBatchSize(syncBatchSize);
        try (Tx tx = this.tx();){
            CommonTx ctx = (CommonTx)tx.unwrap();
            PersistingGroupDao groupDao = ctx.groupDao();
            for (HibGroup group : groupDao.findAll().list()) {
                groupDao.deletePersisted((HibBaseElement)group);
            }
            long groupCount = ctx.count(groupDao.getPersistenceClass());
            Assert.assertEquals((long)0L, (long)groupCount);
            BucketManager bulkManager = this.mesh().bucketManager();
            List buckets = (List)bulkManager.getBuckets(groupCount).toList().blockingGet();
            this.assertBuckets(buckets, syncBatchSize);
            int expectedBucketsCount = 1;
            Assert.assertEquals((long)expectedBucketsCount, (long)buckets.size());
        }
    }

    @Test
    public void testManager() {
        int syncBatchSize = 100;
        this.options().getSearchOptions().setSyncBatchSize(syncBatchSize);
        try (Tx tx = this.tx();){
            int nUsers = 500;
            long total = this.createUsers(nUsers);
            BucketManager bulkManager = this.mesh().bucketManager();
            List buckets = (List)bulkManager.getBuckets(total).toList().blockingGet();
            this.assertBuckets(buckets, syncBatchSize);
            long expectedBucketsCount = MathUtil.ceilDiv((long)(nUsers + 4), (long)syncBatchSize);
            Assert.assertEquals((long)expectedBucketsCount, (long)buckets.size());
        }
    }

    private void assertBuckets(List<Bucket> buckets, int batchSize) {
        Bucket prev = null;
        for (Bucket bucket : buckets) {
            if (prev == null) {
                Assert.assertEquals((String)"The first bucket did not start at 0", (long)0L, (long)bucket.start());
            } else {
                Assert.assertEquals((String)"The buckets did not connect as expected", (long)prev.end(), (long)(bucket.start() - 1));
            }
            prev = bucket;
        }
        Assert.assertEquals((String)"The last bucket did not end with maxInt.", (long)Integer.MAX_VALUE, (long)prev.end());
    }

    private long createUsers(int nUsers) {
        CommonTx ctx = CommonTx.get();
        PersistingUserDao userDao = ctx.userDao();
        for (int i = 0; i < nUsers; ++i) {
            HibUser user = userDao.create("Anton" + i, this.user());
            Assert.assertNotNull((Object)user.getBucketId());
        }
        long userCount = ctx.count(userDao.getPersistenceClass());
        Assert.assertEquals((long)(nUsers + 4), (long)userCount);
        return userCount;
    }
}

