/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.index;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.GenericMessageResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.IndexMaintenanceParametersImpl;
import com.gentics.mesh.search.verticle.eventhandler.SyncEventHandler;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Vertx;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.FULL, startServer=true)
public class IndexClearTest
extends AbstractMeshTest {
    @Before
    public void setup() throws Exception {
        this.getProvider().clear().blockingAwait();
        this.syncIndex();
        this.revokeAdmin();
    }

    @Test
    public void testClear() throws Exception {
        this.waitForEvent(MeshEvent.INDEX_SYNC_FINISHED, () -> SyncEventHandler.invokeSync((Vertx)this.vertx(), null));
        ClientHelper.call(() -> this.client().invokeIndexClear(new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_admin_permission_required", (String[])new String[0]);
        this.grantAdmin();
        GenericMessageResponse message = (GenericMessageResponse)ClientHelper.call(() -> this.client().invokeIndexClear(new ParameterProvider[0]));
        MeshAssertions.assertThat((GenericMessageResponse)message).matches("search_admin_index_clear", new String[0]);
        this.assertDocumentDoesNotExist(HibUser.composeIndexName(), HibUser.composeDocumentId((String)this.userUuid()));
    }

    @Test
    public void testClearWithName() throws Exception {
        this.runClearTest(false);
    }

    @Test
    public void testClearWithFullName() throws Exception {
        this.runClearTest(true);
    }

    protected void runClearTest(boolean prefix) throws Exception {
        String index = prefix ? "mesh-user" : "user";
        this.grantAdmin();
        this.assertDocumentExists(HibProject.composeIndexName(), HibProject.composeDocumentId((String)this.projectUuid()));
        this.assertDocumentExists(HibUser.composeIndexName(), HibUser.composeDocumentId((String)this.userUuid()));
        ClientHelper.call(() -> this.client().invokeIndexClear(new ParameterProvider[]{new IndexMaintenanceParametersImpl().setIndex(index)}));
        this.assertDocumentExists(HibProject.composeIndexName(), HibProject.composeDocumentId((String)this.projectUuid()));
        this.assertDocumentDoesNotExist(HibUser.composeIndexName(), HibUser.composeDocumentId((String)this.userUuid()));
    }
}

