/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.index;

import com.gentics.elasticsearch.client.ElasticsearchClient;
import com.gentics.elasticsearch.client.HttpErrorException;
import com.gentics.mesh.core.data.group.HibGroup;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.role.HibRole;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.search.index.IndexInfo;
import com.gentics.mesh.core.data.tag.HibTag;
import com.gentics.mesh.core.data.tagfamily.HibTagFamily;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.IndexMaintenanceParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.helper.ExpectedEvent;
import io.vertx.core.json.JsonObject;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.FULL, startServer=true)
public class IndexSyncCleanupTest
extends AbstractMeshTest {
    @Before
    public void setup() throws Exception {
        this.getProvider().clear().blockingAwait();
        this.syncIndex();
        this.grantAdmin();
    }

    @Test
    public void testIndexPurge() throws Exception {
        ArrayList<Object> extraIndices = new ArrayList<Object>();
        extraIndices.add("node-blub");
        extraIndices.add("node-blub2");
        extraIndices.add(HibUser.composeIndexName() + "2");
        extraIndices.add(HibGroup.composeIndexName() + "2");
        extraIndices.add(HibRole.composeIndexName() + "2");
        extraIndices.add(HibTagFamily.composeIndexName((String)this.projectUuid()) + "bogus");
        extraIndices.add(HibMicroschema.composeIndexName() + "bogus");
        extraIndices.add(HibSchema.composeIndexName() + "bogus");
        extraIndices.add(HibSchema.composeIndexName() + "bogus");
        extraIndices.add(HibProject.composeIndexName() + "bogus");
        for (String string : extraIndices) {
            this.createIndex(string);
        }
        this.createIndex("different");
        this.createThirdPartyIndex("thirdparty");
        Assertions.assertThat(this.indices()).contains((Object[])new String[]{"thirdparty"}).containsAll((Iterable)extraIndices.stream().map(e -> "mesh-" + e).collect(Collectors.toSet()));
        this.waitForEvent(MeshEvent.INDEX_SYNC_FINISHED, () -> ClientHelper.call(() -> this.client().invokeIndexSync(new ParameterProvider[0])));
        ArrayList<CallSite> remainingIndices = new ArrayList<CallSite>();
        remainingIndices.add((CallSite)((Object)("mesh-" + HibUser.composeIndexName())));
        remainingIndices.add((CallSite)((Object)("mesh-" + HibGroup.composeIndexName())));
        remainingIndices.add((CallSite)((Object)("mesh-" + HibRole.composeIndexName())));
        remainingIndices.add((CallSite)((Object)("mesh-" + HibSchema.composeIndexName())));
        remainingIndices.add((CallSite)((Object)("mesh-" + HibMicroschema.composeIndexName())));
        remainingIndices.add((CallSite)((Object)("mesh-" + HibProject.composeIndexName())));
        remainingIndices.add((CallSite)((Object)("mesh-" + HibTagFamily.composeIndexName((String)this.projectUuid()))));
        remainingIndices.add((CallSite)((Object)("mesh-" + HibTag.composeIndexName((String)this.projectUuid()))));
        Assertions.assertThat(this.indices()).doesNotContainAnyElementsOf(extraIndices).contains((Object[])new String[]{"mesh-different", "thirdparty"}).containsAll(remainingIndices);
    }

    @Test
    public void testSyncWithName() throws Exception {
        this.runSyncTest(false);
    }

    @Test
    public void testSyncWithFullName() throws Exception {
        this.runSyncTest(true);
    }

    protected void runSyncTest(boolean prefix) throws Exception {
        int timeout = 10000;
        String index = prefix ? "mesh-user" : "user";
        this.deleteIndex("mesh-user", "mesh-project");
        this.createThirdPartyIndex("mesh-" + HibUser.composeIndexName());
        this.createThirdPartyIndex("mesh-" + HibProject.composeIndexName());
        try (ExpectedEvent syncFinished = this.expectEvent(MeshEvent.INDEX_SYNC_FINISHED, timeout);){
            ClientHelper.call(() -> this.client().invokeIndexSync(new ParameterProvider[]{new IndexMaintenanceParametersImpl().setIndex(index)}));
        }
        this.assertDocumentDoesNotExist(HibProject.composeIndexName(), HibProject.composeDocumentId((String)this.projectUuid()));
        this.assertDocumentExists(HibUser.composeIndexName(), HibUser.composeDocumentId((String)this.userUuid()));
    }

    private void createThirdPartyIndex(String name) throws HttpErrorException {
        ElasticsearchClient searchClient = (ElasticsearchClient)this.searchProvider().getClient();
        JsonObject response = (JsonObject)searchClient.createIndex(name, (Object)new JsonObject()).sync();
        Assert.assertTrue((boolean)response.getBoolean("acknowledged"));
    }

    private void createIndex(String name) {
        this.searchProvider().createIndex(new IndexInfo(name, new JsonObject(), new JsonObject(), "")).blockingAwait();
    }

    private void deleteIndex(String ... indexNames) throws HttpErrorException {
        ElasticsearchClient searchClient = (ElasticsearchClient)this.searchProvider().getClient();
        searchClient.deleteIndex(indexNames).sync();
    }

    public Set<String> indices() throws HttpErrorException {
        ElasticsearchClient searchClient = (ElasticsearchClient)this.searchProvider().getClient();
        JsonObject indicesAfter = (JsonObject)searchClient.readIndex(new String[]{"*"}).sync();
        return indicesAfter.fieldNames();
    }
}

