/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.index;

import com.gentics.elasticsearch.client.ElasticsearchClient;
import com.gentics.elasticsearch.client.HttpErrorException;
import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.branch.BranchListResponse;
import com.gentics.mesh.core.rest.branch.BranchResponse;
import com.gentics.mesh.core.rest.branch.info.BranchInfoMicroschemaList;
import com.gentics.mesh.core.rest.branch.info.BranchInfoSchemaList;
import com.gentics.mesh.core.rest.branch.info.BranchMicroschemaInfo;
import com.gentics.mesh.core.rest.branch.info.BranchSchemaInfo;
import com.gentics.mesh.core.rest.common.AbstractResponse;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaCreateRequest;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaResponse;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaUpdateRequest;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.MicronodeField;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.LanguageOverrideUtil;
import com.gentics.mesh.core.rest.schema.ListFieldSchema;
import com.gentics.mesh.core.rest.schema.MicronodeFieldSchema;
import com.gentics.mesh.core.rest.schema.MicroschemaModel;
import com.gentics.mesh.core.rest.schema.SchemaModel;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.SchemaUpdateParametersImpl;
import com.gentics.mesh.parameter.client.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.helper.ExpectedEvent;
import com.gentics.mesh.test.helper.UnexpectedEvent;
import com.gentics.mesh.util.Tuple;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.FULL, startServer=true)
public class MicronodeIndexSyncTest
extends AbstractMeshTest {
    protected static final String PROJECT_NAME = "testproject";
    protected static final String SCHEMA_NAME = "schema";
    protected static final String MICROSCHEMA_NAME = "micro";
    protected static final String MICRONODE_FIELD1_NAME = "microfield1";
    protected static final String MICRONODE_FIELD2_NAME = "microfield2";
    protected static final String MICROSCHEMA_FIELD_NAME = "one";
    private ProjectResponse project;
    private String branchUuid;

    @Before
    public void setupTestData() throws Exception {
        this.project = this.createProject(PROJECT_NAME);
        BranchListResponse branches = (BranchListResponse)ClientHelper.call(() -> this.client().findBranches(PROJECT_NAME, new ParameterProvider[0]));
        this.branchUuid = branches.getData().stream().filter(BranchResponse::getLatest).map(AbstractResponse::getUuid).findFirst().orElseThrow(() -> new Exception("Did not find default branch"));
    }

    @Test
    public void testIndexCreation() throws Exception {
        this.createMicroschema(MICROSCHEMA_NAME, req -> req.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)MICROSCHEMA_FIELD_NAME)));
        this.createSchema(SCHEMA_NAME, (SchemaCreateRequest req) -> {
            req.addField((FieldSchema)FieldUtil.createMicronodeFieldSchema((String)MICRONODE_FIELD1_NAME).setAllowedMicroSchemas(new String[]{MICROSCHEMA_NAME}));
            req.addField((FieldSchema)FieldUtil.createListFieldSchema((String)MICRONODE_FIELD2_NAME, (String)"micronode").setAllowedSchemas(new String[]{MICROSCHEMA_NAME}));
        });
        this.waitForSearchIdleEvent();
        this.refreshIndices();
        new TestSchemaInfo(SCHEMA_NAME).assertIndices();
    }

    @Test
    public void testUpdateMicroschema() throws Exception {
        MicroschemaResponse microschema = this.createMicroschema(MICROSCHEMA_NAME, req -> req.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)MICROSCHEMA_FIELD_NAME)));
        this.createSchema(SCHEMA_NAME, (SchemaCreateRequest req) -> {
            req.addField((FieldSchema)FieldUtil.createMicronodeFieldSchema((String)MICRONODE_FIELD1_NAME).setAllowedMicroSchemas(new String[]{MICROSCHEMA_NAME}));
            req.addField((FieldSchema)FieldUtil.createListFieldSchema((String)MICRONODE_FIELD2_NAME, (String)"micronode").setAllowedSchemas(new String[]{MICROSCHEMA_NAME}));
        });
        HashSet<String> draftNodeUuids = new HashSet<String>();
        HashSet<String> publishedNodeUuids = new HashSet<String>();
        for (int i = 0; i < 10; ++i) {
            NodeCreateRequest request = new NodeCreateRequest().setSchemaName(SCHEMA_NAME).setParentNodeUuid(this.project.getRootNode().getUuid()).setLanguage("en");
            if (i % 2 == 0) {
                request.getFields().put(MICRONODE_FIELD1_NAME, (Field)FieldUtil.createMicronodeField((String)MICROSCHEMA_NAME, (Tuple[])new Tuple[]{Tuple.tuple((Object)MICROSCHEMA_FIELD_NAME, (Object)FieldUtil.createStringField((String)"bla"))}));
            }
            NodeResponse node = (NodeResponse)ClientHelper.call(() -> this.client().createNode(PROJECT_NAME, request, new ParameterProvider[0]));
            draftNodeUuids.add(node.getUuid());
            if (i % 3 != 0) continue;
            ClientHelper.call(() -> this.client().publishNode(PROJECT_NAME, node.getUuid(), new ParameterProvider[0]));
            publishedNodeUuids.add(node.getUuid());
        }
        this.waitForSearchIdleEvent();
        this.refreshIndices();
        TestSchemaInfo schemaInfo = new TestSchemaInfo(SCHEMA_NAME).assertIndices().assertIndexedDraftDocuments(draftNodeUuids).assertIndexedPublishedDocuments(publishedNodeUuids);
        String oldDraftIndex = schemaInfo.expectedDraftIndex;
        String oldPublishedIndex = schemaInfo.expectedPublishedIndex;
        this.updateMicroschema(microschema.getUuid(), update -> update.addField((FieldSchema)new StringFieldSchemaImpl().setName("two")));
        this.waitForSearchIdleEvent();
        this.refreshIndices();
        schemaInfo = new TestSchemaInfo(SCHEMA_NAME);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)schemaInfo.expectedDraftIndex).as("draft index name", new Object[0])).isNotEqualTo((Object)oldDraftIndex);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)schemaInfo.expectedPublishedIndex).as("published index name", new Object[0])).isNotEqualTo((Object)oldPublishedIndex);
        schemaInfo.assertIndices().assertIndexedDraftDocuments(draftNodeUuids).assertIndexedPublishedDocuments(publishedNodeUuids);
    }

    @Test
    public void testIndexCheck() throws Exception {
        int timeoutMs = 10000;
        this.createMicroschema(MICROSCHEMA_NAME, req -> req.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)MICROSCHEMA_FIELD_NAME)));
        this.createSchema(SCHEMA_NAME, (SchemaCreateRequest req) -> {
            req.addField((FieldSchema)FieldUtil.createMicronodeFieldSchema((String)MICRONODE_FIELD1_NAME).setAllowedMicroSchemas(new String[]{MICROSCHEMA_NAME}));
            req.addField((FieldSchema)FieldUtil.createListFieldSchema((String)MICRONODE_FIELD2_NAME, (String)"micronode").setAllowedSchemas(new String[]{MICROSCHEMA_NAME}));
        });
        this.waitForSearchIdleEvent();
        this.syncIndex();
        try (ExpectedEvent finished = this.expectEvent(MeshEvent.INDEX_CHECK_FINISHED, timeoutMs);
             UnexpectedEvent syncFinished = this.notExpectEvent(MeshEvent.INDEX_SYNC_FINISHED, timeoutMs);){
            this.vertx().eventBus().publish(MeshEvent.INDEX_CHECK_REQUEST.address, null);
        }
    }

    @Test
    public void testAddFirstMicronodeField() throws Exception {
        String stringFieldName = "stringfield";
        SchemaResponse schema = this.createSchema(SCHEMA_NAME, (SchemaCreateRequest req) -> req.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)stringFieldName)));
        this.waitForSearchIdleEvent();
        HashSet<String> draftNodeUuids = new HashSet<String>();
        HashSet<String> publishedNodeUuids = new HashSet<String>();
        for (int i = 0; i < 10; ++i) {
            NodeCreateRequest request = new NodeCreateRequest().setSchemaName(SCHEMA_NAME).setParentNodeUuid(this.project.getRootNode().getUuid()).setLanguage("en");
            request.getFields().put(stringFieldName, (Field)FieldUtil.createStringField((String)"bla"));
            NodeResponse node = (NodeResponse)ClientHelper.call(() -> this.client().createNode(PROJECT_NAME, request, new ParameterProvider[0]));
            draftNodeUuids.add(node.getUuid());
            if (i % 3 != 0) continue;
            ClientHelper.call(() -> this.client().publishNode(PROJECT_NAME, node.getUuid(), new ParameterProvider[0]));
            publishedNodeUuids.add(node.getUuid());
        }
        this.waitForSearchIdleEvent();
        new TestSchemaInfo(SCHEMA_NAME).assertIndices().assertIndexedDraftDocuments(draftNodeUuids).assertIndexedPublishedDocuments(publishedNodeUuids);
        this.createMicroschema(MICROSCHEMA_NAME, req -> req.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)MICROSCHEMA_FIELD_NAME)));
        this.updateSchema(schema.getUuid(), req -> req.addField((FieldSchema)FieldUtil.createMicronodeFieldSchema((String)MICRONODE_FIELD1_NAME).setAllowedMicroSchemas(new String[]{MICROSCHEMA_NAME})));
        this.waitForSearchIdleEvent();
        this.refreshIndices();
        new TestSchemaInfo(SCHEMA_NAME).assertIndices().assertIndexedDraftDocuments(draftNodeUuids).assertIndexedPublishedDocuments(publishedNodeUuids);
    }

    @Test
    public void testRemoveFirstMicronodeField() throws Exception {
        String stringFieldName = "stringfield";
        this.createMicroschema(MICROSCHEMA_NAME, req -> req.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)MICROSCHEMA_FIELD_NAME)));
        SchemaResponse schema = this.createSchema(SCHEMA_NAME, (SchemaCreateRequest req) -> {
            req.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)stringFieldName));
            req.addField((FieldSchema)FieldUtil.createMicronodeFieldSchema((String)MICRONODE_FIELD1_NAME).setAllowedMicroSchemas(new String[]{MICROSCHEMA_NAME}));
        });
        HashSet<String> draftNodeUuids = new HashSet<String>();
        HashSet<String> publishedNodeUuids = new HashSet<String>();
        for (int i = 0; i < 10; ++i) {
            NodeCreateRequest request = new NodeCreateRequest().setSchemaName(SCHEMA_NAME).setParentNodeUuid(this.project.getRootNode().getUuid()).setLanguage("en");
            if (i % 2 == 0) {
                request.getFields().put(MICRONODE_FIELD1_NAME, (Field)FieldUtil.createMicronodeField((String)MICROSCHEMA_NAME, (Tuple[])new Tuple[]{Tuple.tuple((Object)MICROSCHEMA_FIELD_NAME, (Object)FieldUtil.createStringField((String)"bla"))}));
            }
            NodeResponse node = (NodeResponse)ClientHelper.call(() -> this.client().createNode(PROJECT_NAME, request, new ParameterProvider[0]));
            draftNodeUuids.add(node.getUuid());
            if (i % 3 != 0) continue;
            ClientHelper.call(() -> this.client().publishNode(PROJECT_NAME, node.getUuid(), new ParameterProvider[0]));
            publishedNodeUuids.add(node.getUuid());
        }
        this.waitForSearchIdleEvent();
        this.refreshIndices();
        new TestSchemaInfo(SCHEMA_NAME).assertIndices().assertIndexedDraftDocuments(draftNodeUuids).assertIndexedPublishedDocuments(publishedNodeUuids);
        this.updateSchema(schema.getUuid(), req -> req.removeField(MICRONODE_FIELD1_NAME));
        this.waitForSearchIdleEvent();
        this.refreshIndices();
        new TestSchemaInfo(SCHEMA_NAME).assertIndices().assertIndexedDraftDocuments(draftNodeUuids).assertIndexedPublishedDocuments(publishedNodeUuids);
    }

    @Test
    public void testAddSecondMicronodeField() throws Exception {
        String stringFieldName = "stringfield";
        this.createMicroschema(MICROSCHEMA_NAME, req -> req.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)MICROSCHEMA_FIELD_NAME)));
        SchemaResponse schema = this.createSchema(SCHEMA_NAME, (SchemaCreateRequest req) -> {
            req.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)stringFieldName));
            req.addField((FieldSchema)FieldUtil.createMicronodeFieldSchema((String)MICRONODE_FIELD1_NAME).setAllowedMicroSchemas(new String[]{MICROSCHEMA_NAME}));
        });
        HashSet<String> draftNodeUuids = new HashSet<String>();
        HashSet<String> publishedNodeUuids = new HashSet<String>();
        for (int i = 0; i < 10; ++i) {
            NodeCreateRequest request = new NodeCreateRequest().setSchemaName(SCHEMA_NAME).setParentNodeUuid(this.project.getRootNode().getUuid()).setLanguage("en");
            if (i % 2 == 0) {
                request.getFields().put(MICRONODE_FIELD1_NAME, (Field)FieldUtil.createMicronodeField((String)MICROSCHEMA_NAME, (Tuple[])new Tuple[]{Tuple.tuple((Object)MICROSCHEMA_FIELD_NAME, (Object)FieldUtil.createStringField((String)"bla"))}));
            }
            NodeResponse node = (NodeResponse)ClientHelper.call(() -> this.client().createNode(PROJECT_NAME, request, new ParameterProvider[0]));
            draftNodeUuids.add(node.getUuid());
            if (i % 3 != 0) continue;
            ClientHelper.call(() -> this.client().publishNode(PROJECT_NAME, node.getUuid(), new ParameterProvider[0]));
            publishedNodeUuids.add(node.getUuid());
        }
        this.waitForSearchIdleEvent();
        this.refreshIndices();
        new TestSchemaInfo(SCHEMA_NAME).assertIndices().assertIndexedDraftDocuments(draftNodeUuids).assertIndexedPublishedDocuments(publishedNodeUuids);
        this.updateSchema(schema.getUuid(), req -> req.addField((FieldSchema)FieldUtil.createListFieldSchema((String)MICRONODE_FIELD2_NAME, (String)"micronode").setAllowedSchemas(new String[]{MICROSCHEMA_NAME})));
        this.waitForSearchIdleEvent();
        this.refreshIndices();
        new TestSchemaInfo(SCHEMA_NAME).assertIndices().assertIndexedDraftDocuments(draftNodeUuids).assertIndexedPublishedDocuments(publishedNodeUuids);
    }

    @Test
    public void testRemoveSecondMicronodeField() throws Exception {
        String stringFieldName = "stringfield";
        this.createMicroschema(MICROSCHEMA_NAME, req -> req.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)MICROSCHEMA_FIELD_NAME)));
        SchemaResponse schema = this.createSchema(SCHEMA_NAME, (SchemaCreateRequest req) -> {
            req.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)stringFieldName));
            req.addField((FieldSchema)FieldUtil.createMicronodeFieldSchema((String)MICRONODE_FIELD1_NAME).setAllowedMicroSchemas(new String[]{MICROSCHEMA_NAME}));
            req.addField((FieldSchema)FieldUtil.createListFieldSchema((String)MICRONODE_FIELD2_NAME, (String)"micronode").setAllowedSchemas(new String[]{MICROSCHEMA_NAME}));
        });
        HashSet<String> draftNodeUuids = new HashSet<String>();
        HashSet<String> publishedNodeUuids = new HashSet<String>();
        for (int i = 0; i < 10; ++i) {
            NodeCreateRequest request = new NodeCreateRequest().setSchemaName(SCHEMA_NAME).setParentNodeUuid(this.project.getRootNode().getUuid()).setLanguage("en");
            if (i % 2 == 0) {
                request.getFields().put(MICRONODE_FIELD1_NAME, (Field)FieldUtil.createMicronodeField((String)MICROSCHEMA_NAME, (Tuple[])new Tuple[]{Tuple.tuple((Object)MICROSCHEMA_FIELD_NAME, (Object)FieldUtil.createStringField((String)"bla"))}));
            }
            NodeResponse node = (NodeResponse)ClientHelper.call(() -> this.client().createNode(PROJECT_NAME, request, new ParameterProvider[0]));
            draftNodeUuids.add(node.getUuid());
            if (i % 3 != 0) continue;
            ClientHelper.call(() -> this.client().publishNode(PROJECT_NAME, node.getUuid(), new ParameterProvider[0]));
            publishedNodeUuids.add(node.getUuid());
        }
        this.waitForSearchIdleEvent();
        this.refreshIndices();
        new TestSchemaInfo(SCHEMA_NAME).assertIndices().assertIndexedDraftDocuments(draftNodeUuids).assertIndexedPublishedDocuments(publishedNodeUuids);
        this.updateSchema(schema.getUuid(), req -> req.removeField(MICRONODE_FIELD2_NAME));
        this.waitForSearchIdleEvent();
        this.refreshIndices();
        new TestSchemaInfo(SCHEMA_NAME).assertIndices().assertIndexedDraftDocuments(draftNodeUuids).assertIndexedPublishedDocuments(publishedNodeUuids);
    }

    @Test
    public void testListField() throws Exception {
        String stringFieldName = "stringfield";
        this.createMicroschema(MICROSCHEMA_NAME, req -> req.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)MICROSCHEMA_FIELD_NAME)));
        this.createSchema(SCHEMA_NAME, (SchemaCreateRequest req) -> {
            req.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)stringFieldName));
            req.addField((FieldSchema)FieldUtil.createListFieldSchema((String)MICRONODE_FIELD1_NAME, (String)"micronode").setAllowedSchemas(new String[]{MICROSCHEMA_NAME}));
        });
        HashSet<String> draftNodeUuids = new HashSet<String>();
        HashSet<String> publishedNodeUuids = new HashSet<String>();
        for (int i = 0; i < 10; ++i) {
            NodeCreateRequest request = new NodeCreateRequest().setSchemaName(SCHEMA_NAME).setParentNodeUuid(this.project.getRootNode().getUuid()).setLanguage("en");
            if (i % 2 == 0) {
                request.getFields().put(MICRONODE_FIELD1_NAME, FieldUtil.createMicronodeListField((MicronodeField[])new MicronodeField[]{FieldUtil.createMicronodeField((String)MICROSCHEMA_NAME, (Tuple[])new Tuple[]{Tuple.tuple((Object)MICROSCHEMA_FIELD_NAME, (Object)FieldUtil.createStringField((String)MICROSCHEMA_FIELD_NAME))}), FieldUtil.createMicronodeField((String)MICROSCHEMA_NAME, (Tuple[])new Tuple[]{Tuple.tuple((Object)MICROSCHEMA_FIELD_NAME, (Object)FieldUtil.createStringField((String)"two"))})}));
            }
            NodeResponse node = (NodeResponse)ClientHelper.call(() -> this.client().createNode(PROJECT_NAME, request, new ParameterProvider[0]));
            draftNodeUuids.add(node.getUuid());
            if (i % 3 != 0) continue;
            ClientHelper.call(() -> this.client().publishNode(PROJECT_NAME, node.getUuid(), new ParameterProvider[0]));
            publishedNodeUuids.add(node.getUuid());
        }
        this.waitForSearchIdleEvent();
        this.refreshIndices();
        new TestSchemaInfo(SCHEMA_NAME).assertIndices().assertIndexedDraftDocuments(draftNodeUuids).assertIndexedPublishedDocuments(publishedNodeUuids);
    }

    @Test
    public void testResyncLanguageSpecific() throws Exception {
        this.createMicroschema(MICROSCHEMA_NAME, req -> req.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)MICROSCHEMA_FIELD_NAME)));
        JsonObject esSettings = this.getJson("/elasticsearch/custom/languageOverride.json");
        this.createSchema(SCHEMA_NAME, (SchemaCreateRequest req) -> {
            req.addField((FieldSchema)FieldUtil.createMicronodeFieldSchema((String)MICRONODE_FIELD1_NAME).setAllowedMicroSchemas(new String[]{MICROSCHEMA_NAME}));
            req.setElasticsearch(esSettings);
        });
        HashMap<String, Set> draftNodeUuids = new HashMap<String, Set>();
        HashMap<String, Set> publishedNodeUuids = new HashMap<String, Set>();
        for (String language : Arrays.asList("en", "de")) {
            for (boolean micronode : Arrays.asList(true, false)) {
                for (boolean published : Arrays.asList(true, false)) {
                    NodeCreateRequest request = new NodeCreateRequest().setSchemaName(SCHEMA_NAME).setParentNodeUuid(this.project.getRootNode().getUuid()).setLanguage(language);
                    if (micronode) {
                        request.getFields().put(MICRONODE_FIELD1_NAME, (Field)FieldUtil.createMicronodeField((String)MICROSCHEMA_NAME, (Tuple[])new Tuple[]{Tuple.tuple((Object)MICROSCHEMA_FIELD_NAME, (Object)FieldUtil.createStringField((String)MICROSCHEMA_FIELD_NAME))}));
                    }
                    NodeResponse node = (NodeResponse)ClientHelper.call(() -> this.client().createNode(PROJECT_NAME, request, new ParameterProvider[0]));
                    draftNodeUuids.computeIfAbsent(language, key -> new HashSet()).add(node.getUuid());
                    if (!published) continue;
                    ClientHelper.call(() -> this.client().publishNode(PROJECT_NAME, node.getUuid(), new ParameterProvider[0]));
                    publishedNodeUuids.computeIfAbsent(language, key -> new HashSet()).add(node.getUuid());
                }
            }
        }
        this.waitForSearchIdleEvent();
        this.refreshIndices();
        TestSchemaInfo testSchemaInfo = new TestSchemaInfo(SCHEMA_NAME);
        testSchemaInfo.assertIndices().assertIndexedDraftDocuments("de", (Set)draftNodeUuids.get("de")).assertIndexedDraftDocuments("en", (Set)draftNodeUuids.get("en")).assertIndexedPublishedDocuments("de", (Set)publishedNodeUuids.get("de")).assertIndexedPublishedDocuments("en", (Set)publishedNodeUuids.get("en"));
        this.clearIndex();
        this.syncIndex();
        testSchemaInfo.assertIndices().assertIndexedDraftDocuments("de", (Set)draftNodeUuids.get("de")).assertIndexedDraftDocuments("en", (Set)draftNodeUuids.get("en")).assertIndexedPublishedDocuments("de", (Set)publishedNodeUuids.get("de")).assertIndexedPublishedDocuments("en", (Set)publishedNodeUuids.get("en"));
    }

    protected SchemaResponse createSchema(String name, Consumer<SchemaCreateRequest> requestConsumer) {
        SchemaCreateRequest createSchema = new SchemaCreateRequest();
        createSchema.setName(name);
        requestConsumer.accept(createSchema);
        SchemaResponse schema = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(createSchema, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().assignSchemaToProject(PROJECT_NAME, schema.getUuid()));
        return schema;
    }

    protected void updateSchema(String uuid, Consumer<SchemaModel> updater) {
        this.waitForJob(() -> {
            SchemaResponse schema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(uuid, new ParameterProvider[0]));
            updater.accept((SchemaModel)schema);
            SchemaUpdateRequest updateSchema = (SchemaUpdateRequest)JsonUtil.readValue((String)schema.toJson(), SchemaUpdateRequest.class);
            ClientHelper.call(() -> this.client().updateSchema(uuid, updateSchema, new ParameterProvider[]{new SchemaUpdateParametersImpl().setUpdateAssignedBranches(true)}));
        });
    }

    protected MicroschemaResponse createMicroschema(String name, Consumer<MicroschemaCreateRequest> requestConsumer) {
        MicroschemaCreateRequest createMicroschema = new MicroschemaCreateRequest();
        createMicroschema.setName(name);
        requestConsumer.accept(createMicroschema);
        MicroschemaResponse microschema = (MicroschemaResponse)ClientHelper.call(() -> this.client().createMicroschema(createMicroschema));
        ClientHelper.call(() -> this.client().assignMicroschemaToProject(PROJECT_NAME, microschema.getUuid()));
        return microschema;
    }

    protected void updateMicroschema(String uuid, Consumer<MicroschemaModel> updater) {
        this.waitForJob(() -> {
            MicroschemaResponse microschema = (MicroschemaResponse)ClientHelper.call(() -> this.client().findMicroschemaByUuid(uuid, new ParameterProvider[0]));
            updater.accept((MicroschemaModel)microschema);
            MicroschemaUpdateRequest updateMicroschema = (MicroschemaUpdateRequest)JsonUtil.readValue((String)microschema.toJson(), MicroschemaUpdateRequest.class);
            ClientHelper.call(() -> this.client().updateMicroschema(uuid, updateMicroschema, new ParameterProvider[]{new SchemaUpdateParametersImpl().setUpdateAssignedBranches(true)}));
        });
    }

    protected Set<String> getIndexDocumentIds(String indexName) throws HttpErrorException {
        ElasticsearchClient client = (ElasticsearchClient)this.searchProvider().getClient();
        JsonObject query = new JsonObject().put("query", (Object)new JsonObject().put("query_string", (Object)new JsonObject().put("query", (Object)"*")));
        JsonObject searchResult = (JsonObject)client.search((Object)query, new String[]{indexName}).sync();
        List ids = (List)JsonPath.read((String)searchResult.encode(), (String)"$.hits.hits[*]._id", (Predicate[])new Predicate[0]);
        return new HashSet<String>(ids);
    }

    public class TestSchemaInfo {
        public String schemaVersionUuid;
        public String expectedDraftIndex;
        public Map<String, String> expectedLanguageDraftIndices = new HashMap<String, String>();
        public String expectedPublishedIndex;
        public Map<String, String> expectedLanguagePublishedIndices = new HashMap<String, String>();

        public TestSchemaInfo(String schemaName) throws Exception {
            BranchInfoSchemaList schemaList = (BranchInfoSchemaList)ClientHelper.call(() -> MicronodeIndexSyncTest.this.client().getBranchSchemaVersions(MicronodeIndexSyncTest.PROJECT_NAME, MicronodeIndexSyncTest.this.branchUuid));
            BranchSchemaInfo schemaInfo = schemaList.getSchemas().stream().filter(branchSchemaInfo -> StringUtils.equals((CharSequence)schemaName, (CharSequence)branchSchemaInfo.getName())).findFirst().orElseThrow(() -> new Exception("Schema was not assigned to branch"));
            this.schemaVersionUuid = schemaInfo.getVersionUuid();
            SchemaResponse schema = (SchemaResponse)ClientHelper.call(() -> MicronodeIndexSyncTest.this.client().findSchemaByUuid(schemaInfo.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(schemaInfo.getVersion())}));
            Set microschemaNames = schema.getFields().stream().flatMap(field -> {
                if (field instanceof MicronodeFieldSchema) {
                    return Stream.of(((MicronodeFieldSchema)field).getAllowedMicroSchemas());
                }
                if (field instanceof ListFieldSchema) {
                    if (Objects.equals(((ListFieldSchema)field).getListType(), "micronode")) {
                        return Stream.of(((ListFieldSchema)field).getAllowedSchemas());
                    }
                    return Stream.empty();
                }
                return Stream.empty();
            }).collect(Collectors.toSet());
            HashSet languages = new HashSet();
            if (schema.getElasticsearch() != null) {
                JsonObject esSettings = schema.getElasticsearch();
                languages.addAll(LanguageOverrideUtil.findLanguages((JsonObject)esSettings).collect(Collectors.toSet()));
            }
            BranchInfoMicroschemaList microschemaList = (BranchInfoMicroschemaList)ClientHelper.call(() -> MicronodeIndexSyncTest.this.client().getBranchMicroschemaVersions(MicronodeIndexSyncTest.PROJECT_NAME, MicronodeIndexSyncTest.this.branchUuid));
            TreeSet<String> microschemaUuids = new TreeSet<String>();
            for (String microschema : microschemaNames) {
                microschemaUuids.add(microschemaList.getMicroschemas().stream().filter(branchMicroschemaInfo -> StringUtils.equals((CharSequence)microschema, (CharSequence)branchMicroschemaInfo.getName())).map(BranchMicroschemaInfo::getVersionUuid).findFirst().orElseThrow(() -> new Exception("Microschema " + microschema + " was not assigned to branch")));
            }
            if (microschemaUuids.isEmpty()) {
                this.expectedDraftIndex = String.format("mesh-node-%s-%s-%s-draft", MicronodeIndexSyncTest.this.project.getUuid(), MicronodeIndexSyncTest.this.branchUuid, this.schemaVersionUuid);
                this.expectedPublishedIndex = String.format("mesh-node-%s-%s-%s-published", MicronodeIndexSyncTest.this.project.getUuid(), MicronodeIndexSyncTest.this.branchUuid, this.schemaVersionUuid);
                for (String language : languages) {
                    this.expectedLanguageDraftIndices.put(language, String.format("mesh-node-%s-%s-%s-draft-%s", MicronodeIndexSyncTest.this.project.getUuid(), MicronodeIndexSyncTest.this.branchUuid, this.schemaVersionUuid, language));
                    this.expectedLanguagePublishedIndices.put(language, String.format("mesh-node-%s-%s-%s-published-%s", MicronodeIndexSyncTest.this.project.getUuid(), MicronodeIndexSyncTest.this.branchUuid, this.schemaVersionUuid, language));
                }
            } else {
                String expectedHash = DigestUtils.md5Hex((String)microschemaUuids.stream().collect(Collectors.joining("|")));
                this.expectedDraftIndex = String.format("mesh-node-%s-%s-%s-draft-%s", MicronodeIndexSyncTest.this.project.getUuid(), MicronodeIndexSyncTest.this.branchUuid, this.schemaVersionUuid, expectedHash);
                this.expectedPublishedIndex = String.format("mesh-node-%s-%s-%s-published-%s", MicronodeIndexSyncTest.this.project.getUuid(), MicronodeIndexSyncTest.this.branchUuid, this.schemaVersionUuid, expectedHash);
                for (String language : languages) {
                    this.expectedLanguageDraftIndices.put(language, String.format("mesh-node-%s-%s-%s-draft-%s-%s", MicronodeIndexSyncTest.this.project.getUuid(), MicronodeIndexSyncTest.this.branchUuid, this.schemaVersionUuid, language, expectedHash));
                    this.expectedLanguagePublishedIndices.put(language, String.format("mesh-node-%s-%s-%s-published-%s-%s", MicronodeIndexSyncTest.this.project.getUuid(), MicronodeIndexSyncTest.this.branchUuid, this.schemaVersionUuid, language, expectedHash));
                }
            }
        }

        public TestSchemaInfo assertIndices() throws Exception {
            ElasticsearchClient client = (ElasticsearchClient)MicronodeIndexSyncTest.this.searchProvider().getClient();
            String indexNamePattern = String.format("mesh-node-%s-%s-%s*", MicronodeIndexSyncTest.this.project.getUuid(), MicronodeIndexSyncTest.this.branchUuid, this.schemaVersionUuid);
            JsonObject indexResponse = (JsonObject)client.readIndex(new String[]{indexNamePattern}).sync();
            HashSet<String> allIndices = new HashSet<String>();
            allIndices.add(this.expectedDraftIndex);
            allIndices.addAll(this.expectedLanguageDraftIndices.values());
            allIndices.add(this.expectedPublishedIndex);
            allIndices.addAll(this.expectedLanguagePublishedIndices.values());
            Assertions.assertThat((Iterable)indexResponse.fieldNames()).as("Index names", new Object[0]).containsOnlyElementsOf(allIndices);
            return this;
        }

        public TestSchemaInfo assertIndexedDraftDocuments(Set<String> uuids) throws HttpErrorException {
            return this.assertIndexedDraftDocuments("en", uuids);
        }

        public TestSchemaInfo assertIndexedDraftDocuments(String language, Set<String> uuids) throws HttpErrorException {
            String indexName = this.expectedLanguageDraftIndices.getOrDefault(language, this.expectedDraftIndex);
            Assertions.assertThat(MicronodeIndexSyncTest.this.getIndexDocumentIds(indexName)).as("Documents in index " + indexName, new Object[0]).containsOnlyElementsOf((Iterable)uuids.stream().map(uuid -> ContentDao.composeDocumentId((String)uuid, (String)language)).collect(Collectors.toSet()));
            return this;
        }

        public TestSchemaInfo assertIndexedPublishedDocuments(Set<String> uuids) throws HttpErrorException {
            return this.assertIndexedPublishedDocuments("en", uuids);
        }

        public TestSchemaInfo assertIndexedPublishedDocuments(String language, Set<String> uuids) throws HttpErrorException {
            String indexName = this.expectedLanguagePublishedIndices.getOrDefault(language, this.expectedPublishedIndex);
            Assertions.assertThat(MicronodeIndexSyncTest.this.getIndexDocumentIds(indexName)).as("Documents in index " + indexName, new Object[0]).containsOnlyElementsOf((Iterable)uuids.stream().map(uuid -> ContentDao.composeDocumentId((String)uuid, (String)language)).collect(Collectors.toSet()));
            return this;
        }
    }
}

