/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.index;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.common.GenericMessageResponse;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestHelper;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.FULL, startServer=true)
public class NodeIndexSyncTest
extends AbstractMeshTest {
    @Test
    public void testNodeSync() throws Exception {
        this.recreateIndices();
        String oldContent = "supersonic";
        String newContent = "urschnell";
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", newContent), new ParameterProvider[0]));
        MeshAssertions.assertThat((List)response.getData()).as("Published search result", new Object[0]).isEmpty();
        String uuid = (String)this.db().tx(() -> this.content("concorde").getUuid());
        NodeResponse concorde = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        ClientHelper.call(() -> this.client().publishNode("dummy", uuid, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", oldContent), new ParameterProvider[0]));
        ((AbstractListAssert)MeshAssertions.assertThat((List)response.getData()).as("Published search result", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new NodeResponse[]{concorde});
        this.grantAdmin();
        this.searchProvider().clear().blockingAwait();
        GenericMessageResponse message = (GenericMessageResponse)ClientHelper.call(() -> this.client().invokeIndexSync(new ParameterProvider[0]));
        MeshAssertions.assertThat((GenericMessageResponse)message).matches("search_admin_index_sync_invoked", new String[0]);
        this.waitForSearchIdleEvent();
        response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", oldContent), new ParameterProvider[0]));
        ((AbstractListAssert)MeshAssertions.assertThat((List)response.getData()).as("Published search result", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new NodeResponse[]{concorde});
    }
}

