/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.index;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.common.GenericMessageResponse;
import com.gentics.mesh.core.rest.search.EntityMetrics;
import com.gentics.mesh.core.rest.search.SearchStatusResponse;
import com.gentics.mesh.core.rest.user.UserListResponse;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestHelper;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractListAssert;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.FULL, startServer=true)
public class UserIndexSyncTest
extends AbstractMeshTest {
    @Test
    public void testUserSync() throws Exception {
        int syncBatchSize = 10;
        this.options().getSearchOptions().setSyncBatchSize(syncBatchSize);
        String newUsername = "peterpan";
        int nUsers = 20;
        try (Tx tx2 = this.tx();){
            UserDao userDao = tx2.userDao();
            for (int i = 0; i < nUsers; ++i) {
                userDao.create("Anton" + i, this.user());
            }
            tx2.success();
        }
        this.recreateIndices();
        UserListResponse userList = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(MeshTestHelper.getSimpleTermQuery("username.raw", newUsername), new ParameterProvider[0]));
        MeshAssertions.assertThat((List)userList.getData()).as("Search result", new Object[0]).isEmpty();
        this.grantAdmin();
        this.searchProvider().clear().blockingAwait();
        String newUserUuid = (String)this.tx(tx -> {
            UserDao userDao = tx.userDao();
            RoleDao roleDao = tx.roleDao();
            HibUser user = userDao.create(newUsername, this.user());
            roleDao.grantPermissions(this.role(), (HibBaseElement)user, InternalPermission.values());
            return user.getUuid();
        });
        UserResponse newUser = (UserResponse)ClientHelper.call(() -> this.client().findUserByUuid(newUserUuid, new ParameterProvider[0]));
        GenericMessageResponse message = (GenericMessageResponse)ClientHelper.call(() -> this.client().invokeIndexSync(new ParameterProvider[0]));
        MeshAssertions.assertThat((GenericMessageResponse)message).matches("search_admin_index_sync_invoked", new String[0]);
        this.waitForSearchIdleEvent();
        userList = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(MeshTestHelper.getSimpleTermQuery("username.raw", newUsername), new ParameterProvider[0]));
        Assert.assertEquals((long)1L, (long)userList.getData().size());
        ((AbstractListAssert)MeshAssertions.assertThat((List)userList.getData()).as("Search result", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new UserResponse[]{newUser});
        message = (GenericMessageResponse)ClientHelper.call(() -> this.client().invokeIndexSync(new ParameterProvider[0]));
        MeshAssertions.assertThat((GenericMessageResponse)message).matches("search_admin_index_sync_invoked", new String[0]);
        this.waitForSearchIdleEvent();
        SearchStatusResponse status = (SearchStatusResponse)ClientHelper.call(() -> this.client().searchStatus());
        for (Map.Entry entry : status.getMetrics().entrySet()) {
            String name = (String)entry.getKey();
            EntityMetrics metric = (EntityMetrics)entry.getValue();
            Assert.assertEquals((String)("The type {" + name + "} should not track any deletes during the sync"), (long)0L, (long)metric.getDelete().getSynced());
            Assert.assertEquals((String)("The type {" + name + "} should not track any inserts during the sync"), (long)0L, (long)metric.getInsert().getSynced());
            Assert.assertEquals((String)("The type {" + name + "} should not track any updates during the sync"), (long)0L, (long)metric.getUpdate().getSynced());
        }
    }
}

