/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.migration;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.search.migration.NodeMigrationSearchTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshCoreOptionChanger;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.util.IndexOptionHelper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true, optionChanger=MeshCoreOptionChanger.BATCH_MIGRATION)
public class BatchedNodeMigrationSearchTest
extends NodeMigrationSearchTest {
    public BatchedNodeMigrationSearchTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Test
    public void testNodeMigrationBatch() {
        String rootFolderUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        String SCHEMA_NAME = "batchSchema";
        SchemaCreateRequest schemaCreateRequest = new SchemaCreateRequest();
        schemaCreateRequest.setName("batchSchema");
        schemaCreateRequest.getFields().add(FieldUtil.createStringFieldSchema((String)"name").setElasticsearch(IndexOptionHelper.getRawFieldOption()));
        SchemaResponse schemaResponse = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(schemaCreateRequest, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schemaResponse.getUuid()));
        for (int i = 0; i < 100; ++i) {
            NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
            nodeCreateRequest.setParentNodeUuid(rootFolderUuid);
            nodeCreateRequest.setSchemaName("batchSchema");
            nodeCreateRequest.setLanguage("en");
            nodeCreateRequest.getFields().put("name", (Field)FieldUtil.createStringField((String)"value"));
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
            Assert.assertEquals((String)("Schema version does not match expected " + schemaResponse.getVersion()), (Object)schemaResponse.getVersion(), (Object)response.getSchema().getVersion());
        }
        this.waitForSearchIdleEvent();
        Assert.assertEquals((long)100L, (long)((NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", this.queryName("value"), new ParameterProvider[0]))).getMetainfo().getTotalCount());
        SchemaUpdateRequest schemaUpdateRequest = schemaResponse.toUpdateRequest();
        schemaUpdateRequest.getFields().add(FieldUtil.createStringFieldSchema((String)"another"));
        this.grantAdmin();
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(schemaResponse.getUuid(), schemaUpdateRequest, new ParameterProvider[0])), JobStatus.COMPLETED, 1, 120);
        this.waitForSearchIdleEvent();
        NodeListResponse searchResponse = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", this.queryName("value"), new ParameterProvider[0]));
        Assert.assertEquals((long)100L, (long)searchResponse.getMetainfo().getTotalCount());
        for (NodeResponse response : searchResponse.getData()) {
            Assert.assertNotEquals((String)("Schema version should not match expected " + schemaResponse.getVersion()), (Object)schemaResponse.getVersion(), (Object)response.getSchema().getVersion());
        }
    }
}

