/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.migration;

import com.gentics.mesh.Mesh;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.rest.client.MeshWebsocket;
import com.gentics.mesh.search.AbstractNodeSearchEndpointTest;
import com.gentics.mesh.search.verticle.eventhandler.SyncEventHandler;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeMigrationDuringSyncTest
extends AbstractNodeSearchEndpointTest {
    public NodeMigrationDuringSyncTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Test
    public void testSyncDuringMigration() throws Exception {
        this.recreateIndices();
        NodeResponse parent = this.createNode();
        IntStream.range(0, 1000).forEach(i -> this.createNode(parent));
        this.waitForSearchIdleEvent();
        this.migrateSchema("folder", false).blockingAwait();
        AtomicInteger fullSyncs = new AtomicInteger(0);
        MeshWebsocket eventbus = this.client().eventbus();
        eventbus.registerEvents(new MeshEvent[]{MeshEvent.INDEX_SYNC_REQUEST});
        eventbus.events().subscribe(ev -> fullSyncs.incrementAndGet());
        Thread.sleep(1000L);
        SyncEventHandler.invokeSyncCompletable((Mesh)this.meshApi()).blockingAwait(30L, TimeUnit.SECONDS);
        this.waitForSearchIdleEvent();
        Assertions.assertThat((int)fullSyncs.get()).isEqualTo(1);
        eventbus.close();
    }
}

