/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.migration;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.rest.job.JobListResponse;
import com.gentics.mesh.core.rest.job.JobResponse;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.job.warning.JobWarning;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.SchemaListResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.SchemaUpdateParametersImpl;
import com.gentics.mesh.parameter.impl.SearchParametersImpl;
import com.gentics.mesh.search.AbstractNodeSearchEndpointTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.category.FailingTests;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.util.IndexOptionHelper;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeMigrationSearchTest
extends AbstractNodeSearchEndpointTest {
    public NodeMigrationSearchTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    public String queryName(String value) {
        return MeshTestHelper.getSimpleTermQuery("fields.name.raw", value);
    }

    @Test
    public void testNodeMigrationConflict() {
        NodeCreateRequest nodeCreateRequest;
        int i;
        String rootFolderUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        String SCHEMA_NAME = "testSchema";
        SchemaCreateRequest schemaCreateRequest = new SchemaCreateRequest();
        schemaCreateRequest.setName("testSchema");
        schemaCreateRequest.getFields().add(FieldUtil.createStringFieldSchema((String)"name").setElasticsearch(IndexOptionHelper.getRawFieldOption()));
        SchemaResponse schemaResponse = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(schemaCreateRequest, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schemaResponse.getUuid()));
        for (i = 0; i < 5; ++i) {
            nodeCreateRequest = new NodeCreateRequest();
            nodeCreateRequest.setParentNodeUuid(rootFolderUuid);
            nodeCreateRequest.setSchemaName("testSchema");
            nodeCreateRequest.setLanguage("en");
            nodeCreateRequest.getFields().put("name", (Field)FieldUtil.createStringField((String)("value" + i)));
            ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        }
        for (i = 0; i < 10; ++i) {
            nodeCreateRequest = new NodeCreateRequest();
            nodeCreateRequest.setParentNodeUuid(rootFolderUuid);
            nodeCreateRequest.setSchemaName("testSchema");
            nodeCreateRequest.setLanguage("en");
            nodeCreateRequest.getFields().put("name", (Field)FieldUtil.createStringField((String)"sameValue"));
            ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        }
        this.waitForSearchIdleEvent();
        Assert.assertEquals((long)10L, (long)((NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", this.queryName("sameValue"), new ParameterProvider[0]))).getMetainfo().getTotalCount());
        SchemaUpdateRequest schemaUpdateRequest = new SchemaUpdateRequest();
        schemaUpdateRequest.setName("testSchema");
        schemaUpdateRequest.getFields().add(FieldUtil.createStringFieldSchema((String)"name").setElasticsearch(IndexOptionHelper.getRawFieldOption()));
        schemaUpdateRequest.setSegmentField("name");
        this.grantAdmin();
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(schemaResponse.getUuid(), schemaUpdateRequest, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        this.waitForSearchIdleEvent();
        Assert.assertEquals((long)1L, (long)((NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", this.queryName("sameValue"), new ParameterProvider[0]))).getMetainfo().getTotalCount());
        for (int i2 = 0; i2 < 9; ++i2) {
            String expectedName = "sameValue_" + (i2 + 1);
            Assert.assertEquals((String)("Could not find expected name {" + expectedName + "}"), (long)1L, (long)((NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", this.queryName(expectedName), new ParameterProvider[0]))).getMetainfo().getTotalCount());
        }
        NodeCreateRequest nodeCreateRequest2 = new NodeCreateRequest();
        nodeCreateRequest2.setParentNodeUuid(rootFolderUuid);
        nodeCreateRequest2.setSchemaName("testSchema");
        nodeCreateRequest2.setLanguage("en");
        nodeCreateRequest2.getFields().put("name", (Field)FieldUtil.createStringField((String)"sameValue"));
        ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest2, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"node_conflicting_segmentfield_update", (String[])new String[]{"name", "sameValue"});
        this.runAsAdmin(() -> {
            JobListResponse jobs = (JobListResponse)ClientHelper.call(() -> this.client().findJobs(new ParameterProvider[0]));
            JobResponse job = (JobResponse)jobs.getData().get(0);
            Assert.assertEquals((Object)"node-conflict-resolution", (Object)((JobWarning)job.getWarnings().get(0)).getType());
        });
    }

    @Test
    public void testSearchAfterSchemaUpdate() throws Exception {
        this.recreateIndices();
        String query = MeshTestHelper.getSimpleTermQuery("schema.name.raw", "content");
        long oldCount = ((NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", query, new ParameterProvider[0]))).getMetainfo().getTotalCount();
        SchemaResponse schema = ((SchemaListResponse)ClientHelper.call(() -> this.client().findSchemas("dummy", new ParameterProvider[0]))).getData().stream().filter(it -> it.getName().equals("content")).findAny().get();
        List fields = schema.getFields();
        fields.add(new StringFieldSchemaImpl().setName("test").setLabel("Test"));
        this.grantAdmin();
        this.waitForJobs(() -> {
            SchemaUpdateRequest updateRequest = new SchemaUpdateRequest().setFields(fields).setName(schema.getName());
            ClientHelper.call(() -> this.client().updateSchema(schema.getUuid(), updateRequest, new ParameterProvider[]{new SchemaUpdateParametersImpl().setUpdateAssignedBranches(true)}));
        }, JobStatus.COMPLETED, 1);
        this.waitForSearchIdleEvent();
        long newCount = ((NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", query, new ParameterProvider[0]))).getMetainfo().getTotalCount();
        Assertions.assertThat((long)newCount).isEqualTo(oldCount);
    }

    @Test
    @Category(value={FailingTests.class})
    public void searchDuringMigration() throws Exception {
        String query = MeshTestHelper.getSimpleTermQuery("schema.name.raw", "folder");
        this.recreateIndices();
        this.waitForSearchIdleEvent(() -> {
            NodeResponse parent = this.createNode();
            IntStream.range(0, 1000).forEach(i -> this.createNode(parent));
        });
        NodeListResponse beforeMigration = (NodeListResponse)this.client().searchNodes(query, new ParameterProvider[0]).blockingGet();
        this.waitForLatestJob(() -> {
            this.migrateSchema("folder", false).blockingAwait();
            this.sleep(1000L);
            NodeListResponse duringMigration = (NodeListResponse)this.client().searchNodes(query, new ParameterProvider[]{new SearchParametersImpl().setWait(false)}).blockingGet();
            Assertions.assertThat((long)beforeMigration.getMetainfo().getTotalCount()).isEqualTo(duringMigration.getMetainfo().getTotalCount()).as("All nodes must be found during migration", new Object[0]);
        });
        this.waitForSearchIdleEvent();
    }
}

