/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.permission;

import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.group.HibGroup;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.role.HibRole;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.group.GroupListResponse;
import com.gentics.mesh.core.rest.group.GroupResponse;
import com.gentics.mesh.core.rest.role.RolePermissionRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class GroupPermissionSearchTest
extends AbstractMeshTest {
    @Test
    public void testReadPermHandling() throws Exception {
        String groupname = "testgroup42a";
        GroupResponse response = this.createGroup(groupname);
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            HibGroup group = (HibGroup)tx.groupDao().findByUuid(response.getUuid());
            System.out.println("Group Uuid:" + response.getUuid());
            for (HibRole role : userDao.getRoles(this.user())) {
                roleDao.revokePermissions(role, (HibBaseElement)group, new InternalPermission[]{InternalPermission.READ_PERM});
            }
            tx.success();
        }
        this.recreateIndices();
        String json = this.getESText("groupWildcard.es");
        GroupListResponse list = (GroupListResponse)ClientHelper.call(() -> this.client().searchGroups(json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The group should not be found since the requestor has no permission to see it", (long)0L, (long)list.getData().size());
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibGroup group = (HibGroup)tx.groupDao().findByUuid(response.getUuid());
            System.out.println("Group Uuid:" + response.getUuid());
            roleDao.grantPermissions(this.role(), (HibBaseElement)group, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        this.recreateIndices();
        list = (GroupListResponse)ClientHelper.call(() -> this.client().searchGroups(json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The group should be found since we added the permission to see it", (long)1L, (long)list.getData().size());
    }

    @Test
    public void testIndexPermUpdate() throws Exception {
        String groupname = "testgroup42a";
        GroupResponse response = this.createGroup(groupname);
        String json = this.getESText("groupWildcard.es");
        this.waitForSearchIdleEvent();
        GroupListResponse list = (GroupListResponse)ClientHelper.call(() -> this.client().searchGroups(json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The group should be found since the requestor has permission to see it", (long)1L, (long)list.getData().size());
        RolePermissionRequest request = new RolePermissionRequest();
        request.getPermissions().setRead(Boolean.valueOf(false));
        ClientHelper.call(() -> this.client().updateRolePermissions(this.roleUuid(), "/groups/" + response.getUuid(), request));
        this.waitForSearchIdleEvent();
        list = (GroupListResponse)ClientHelper.call(() -> this.client().searchGroups(json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The group should not be found since the requestor has no permission to see it", (long)0L, (long)list.getData().size());
    }
}

