/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.permission;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.role.RoleCreateRequest;
import com.gentics.mesh.core.rest.role.RolePermissionRequest;
import com.gentics.mesh.core.rest.role.RoleResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class NodePermissionSearchTest
extends AbstractMeshTest {
    @Test
    public void testIndexPermUpdate() throws Exception {
        NodeResponse response = this.createNode("slug", (Field)FieldUtil.createStringField((String)"slugblub"));
        String json = this.getESText("nodeWildcard.es");
        this.waitForSearchIdleEvent();
        NodeListResponse list = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The node should be found since the requestor has permission to see it", (long)1L, (long)list.getData().size());
        RolePermissionRequest request = new RolePermissionRequest();
        request.getPermissions().setRead(Boolean.valueOf(false));
        ClientHelper.call(() -> this.client().updateRolePermissions(this.roleUuid(), "/projects/dummy/nodes/" + response.getUuid(), request));
        this.waitForSearchIdleEvent();
        list = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The node should not be found since the requestor has no permission to see it", (long)0L, (long)list.getData().size());
    }

    @Test
    public void testIndexPermRoleDeletion() throws Exception {
        this.recreateIndices();
        this.createNode("slug", (Field)FieldUtil.createStringField((String)"slugblub"));
        String json = this.getESText("nodeWildcard.es");
        this.waitForSearchIdleEvent();
        NodeListResponse list = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The node should be found since the requestor has permission to see it", (long)1L, (long)list.getData().size());
        ClientHelper.call(() -> this.client().deleteRole(this.roleUuid()));
        this.waitForSearchIdleEvent();
        list = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The node should not be found since the requestor has no permission to see it", (long)0L, (long)list.getData().size());
    }

    @Test
    public void testReadPublishPerm() throws Exception {
        this.recreateIndices();
        NodeResponse response = this.createNode("slug", (Field)FieldUtil.createStringField((String)"slugblub"));
        ClientHelper.call(() -> this.client().publishNode("dummy", response.getUuid(), new ParameterProvider[0]));
        String json = this.getESText("nodeWildcard.es");
        this.waitForSearchIdleEvent();
        NodeListResponse list = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", json, new ParameterProvider[]{new VersioningParametersImpl().published()}));
        Assert.assertEquals((String)"The node should be found since the requestor has permission to see it", (long)1L, (long)list.getData().size());
        RolePermissionRequest request = new RolePermissionRequest();
        request.getPermissions().setRead(Boolean.valueOf(false));
        request.getPermissions().setReadPublished(Boolean.valueOf(true));
        ClientHelper.call(() -> this.client().updateRolePermissions(this.roleUuid(), "/projects/dummy/nodes/" + response.getUuid(), request));
        this.waitForSearchIdleEvent();
        list = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", json, new ParameterProvider[]{new VersioningParametersImpl().published()}));
        Assert.assertEquals((String)"The node should be found since the requestor has permission read publish", (long)1L, (long)list.getData().size());
        this.tx(tx -> tx.roleDao().grantPermissions(this.role(), (HibBaseElement)tx.nodeDao().findByUuidGlobal(response.getUuid()), new InternalPermission[]{InternalPermission.READ_PERM}));
        request.getPermissions().setReadPublished(Boolean.valueOf(false));
        ClientHelper.call(() -> this.client().updateRolePermissions(this.roleUuid(), "/projects/dummy/nodes/" + response.getUuid(), request));
        this.waitForSearchIdleEvent();
        list = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", json, new ParameterProvider[]{new VersioningParametersImpl().published()}));
        Assert.assertEquals((String)"The node should not be found since the requestor has no permission to see it", (long)0L, (long)list.getData().size());
    }

    @Test
    public void testRoleDeletion() throws Exception {
        this.recreateIndices();
        NodeResponse response = this.createNode("slug", (Field)FieldUtil.createStringField((String)"slugblub"));
        ClientHelper.call(() -> this.client().publishNode("dummy", response.getUuid(), new ParameterProvider[0]));
        String json = this.getESText("nodeWildcard.es");
        this.waitForSearchIdleEvent();
        NodeListResponse list = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", json, new ParameterProvider[]{new VersioningParametersImpl().published()}));
        Assert.assertEquals((String)"The node should be found since the requestor has permission to see it", (long)1L, (long)list.getData().size());
        RoleResponse roleResponse = (RoleResponse)ClientHelper.call(() -> this.client().createRole(new RoleCreateRequest().setName("ReadpubPermRole")));
        RolePermissionRequest request = new RolePermissionRequest();
        request.getPermissions().setRead(Boolean.valueOf(false));
        request.getPermissions().setReadPublished(Boolean.valueOf(true));
        ClientHelper.call(() -> this.client().updateRolePermissions(roleResponse.getUuid(), "/projects/dummy/nodes/" + response.getUuid(), request));
        ClientHelper.call(() -> this.client().addRoleToGroup(this.groupUuid(), roleResponse.getUuid()));
        RolePermissionRequest request2 = new RolePermissionRequest();
        request2.getPermissions().setRead(Boolean.valueOf(false));
        request2.getPermissions().setReadPublished(Boolean.valueOf(false));
        ClientHelper.call(() -> this.client().updateRolePermissions(this.roleUuid(), "/projects/dummy/nodes/" + response.getUuid(), request2));
        this.waitForSearchIdleEvent();
        list = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", json, new ParameterProvider[]{new VersioningParametersImpl().published()}));
        Assert.assertEquals((String)"The node should be found since the requestor has permission read publish", (long)1L, (long)list.getData().size());
        ClientHelper.call(() -> this.client().deleteRole(roleResponse.getUuid()));
        this.waitForSearchIdleEvent();
        list = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", json, new ParameterProvider[]{new VersioningParametersImpl().published()}));
        Assert.assertEquals((String)"The node should not be found since the requestor has no permission to see it", (long)0L, (long)list.getData().size());
        RoleResponse roleResponse2 = (RoleResponse)ClientHelper.call(() -> this.client().createRole(roleResponse.getUuid(), new RoleCreateRequest().setName("ReadpubPermRole2")));
        ClientHelper.call(() -> this.client().addRoleToGroup(this.groupUuid(), roleResponse2.getUuid()));
        this.waitForSearchIdleEvent();
        list = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", json, new ParameterProvider[]{new VersioningParametersImpl().published()}));
        Assert.assertEquals((String)"The node should not be found since the requestor has no permission to see it", (long)0L, (long)list.getData().size());
    }

    @Test
    public void testRoleDeletionMultipleNodes() throws Exception {
        int childNodeCount = 30;
        this.recreateIndices();
        NodeResponse response = this.createNode("slug", (Field)FieldUtil.createStringField((String)"slugblub"));
        ClientHelper.call(() -> this.client().publishNode("dummy", response.getUuid(), new ParameterProvider[0]));
        String json = this.getESText("nodeWildcard.es");
        this.waitForSearchIdleEvent();
        NodeListResponse list = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", json, new ParameterProvider[]{new VersioningParametersImpl().published()}));
        Assert.assertEquals((String)"The node should be found since the requestor has permission to see it", (long)1L, (long)list.getData().size());
        RoleResponse roleResponse = (RoleResponse)ClientHelper.call(() -> this.client().createRole(new RoleCreateRequest().setName("ReadpubPermRole")));
        RolePermissionRequest request = new RolePermissionRequest();
        request.getPermissions().setRead(Boolean.valueOf(false));
        request.getPermissions().setReadPublished(Boolean.valueOf(true));
        request.setRecursive(Boolean.valueOf(true));
        ClientHelper.call(() -> this.client().addRoleToGroup(this.groupUuid(), roleResponse.getUuid()));
        ClientHelper.call(() -> this.client().updateRolePermissions(roleResponse.getUuid(), "/projects/dummy/nodes/" + response.getUuid(), request));
        System.out.println("Creating children...");
        this.createChildren(response, childNodeCount);
        System.out.println("Done creating children...");
        RolePermissionRequest request2 = new RolePermissionRequest();
        request2.getPermissions().setRead(Boolean.valueOf(false));
        request2.getPermissions().setReadPublished(Boolean.valueOf(false));
        request2.setRecursive(Boolean.valueOf(true));
        ClientHelper.call(() -> this.client().updateRolePermissions(this.roleUuid(), "/projects/dummy/nodes/" + response.getUuid(), request2));
        this.waitForSearchIdleEvent();
        list = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", json, new ParameterProvider[]{new VersioningParametersImpl().published()}));
        Assert.assertEquals((String)"The nodes should be found since the requestor has permission read publish", (long)(1 + childNodeCount), (long)list.getMetainfo().getTotalCount());
        ClientHelper.call(() -> this.client().deleteRole(roleResponse.getUuid()));
        this.waitForSearchIdleEvent();
        list = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", json, new ParameterProvider[]{new VersioningParametersImpl().published()}));
        Assert.assertEquals((String)"The node should not be found since the requestor has no permission to see it", (long)0L, (long)list.getMetainfo().getTotalCount());
        RoleResponse roleResponse2 = (RoleResponse)ClientHelper.call(() -> this.client().createRole(roleResponse.getUuid(), new RoleCreateRequest().setName("ReadpubPermRole2")));
        ClientHelper.call(() -> this.client().addRoleToGroup(this.groupUuid(), roleResponse2.getUuid()));
        this.waitForSearchIdleEvent();
        list = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", json, new ParameterProvider[]{new VersioningParametersImpl().published()}));
        Assert.assertEquals((String)"The node should not be found since the requestor has no permission to see it", (long)0L, (long)list.getMetainfo().getTotalCount());
    }

    private void createChildren(NodeResponse parent, int childNodeCount) {
        for (int i = 0; i < childNodeCount; ++i) {
            NodeResponse node = this.createNode(parent.getUuid(), "slug", (Field)FieldUtil.createStringField((String)("slugblub" + i)));
            this.client().publishNode("dummy", node.getUuid(), new ParameterProvider[0]).blockingAwait();
        }
    }
}

