/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.permission;

import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.TagFamilyDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.role.HibRole;
import com.gentics.mesh.core.data.tagfamily.HibTagFamily;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.role.RolePermissionRequest;
import com.gentics.mesh.core.rest.tag.TagFamilyListResponse;
import com.gentics.mesh.core.rest.tag.TagFamilyResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class TagFamilyPermissionSearchTest
extends AbstractMeshTest {
    @Test
    public void testReadPermHandling() throws Exception {
        String tagfamilyname = "testtagfamily42a";
        TagFamilyResponse response = this.createTagFamily("dummy", tagfamilyname);
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            RoleDao roleDao = tx.roleDao();
            HibTagFamily tagFamily = (HibTagFamily)tx.tagFamilyDao().findByUuid((HibCoreElement)this.project(), response.getUuid());
            System.out.println("TagFamily Uuid:" + response.getUuid());
            for (HibRole role : userDao.getRoles(this.user())) {
                roleDao.revokePermissions(role, (HibBaseElement)tagFamily, new InternalPermission[]{InternalPermission.READ_PERM});
            }
            tx.success();
        }
        this.recreateIndices();
        String json = this.getESText("tagFamilyWildcard.es");
        TagFamilyListResponse list = (TagFamilyListResponse)ClientHelper.call(() -> this.client().searchTagFamilies(json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The tagFamily should not be found since the requestor has no permission to see it", (long)0L, (long)list.getData().size());
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            RoleDao roleDao = tx.roleDao();
            TagFamilyDao tagFamilyDao = tx.tagFamilyDao();
            HibTagFamily tagFamily = (HibTagFamily)tagFamilyDao.findByUuid((HibCoreElement)this.project(), response.getUuid());
            System.out.println("TagFamily Uuid:" + response.getUuid());
            for (HibRole role : userDao.getRoles(this.user())) {
                roleDao.grantPermissions(role, (HibBaseElement)tagFamily, new InternalPermission[]{InternalPermission.READ_PERM});
            }
            tx.success();
        }
        this.recreateIndices();
        list = (TagFamilyListResponse)ClientHelper.call(() -> this.client().searchTagFamilies(json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The tagFamily should be found since we added the permission to see it", (long)1L, (long)list.getData().size());
    }

    @Test
    public void testIndexPermUpdate() throws Exception {
        this.recreateIndices();
        String tagfamilyName = "testtagfamily42a";
        TagFamilyResponse response = this.createTagFamily("dummy", tagfamilyName);
        this.waitForSearchIdleEvent();
        String json = this.getESText("tagFamilyWildcard.es");
        TagFamilyListResponse list = (TagFamilyListResponse)ClientHelper.call(() -> this.client().searchTagFamilies(json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The tagFamily should be found since the requestor has permission to see it", (long)1L, (long)list.getData().size());
        RolePermissionRequest request = new RolePermissionRequest();
        request.getPermissions().setRead(Boolean.valueOf(false));
        ClientHelper.call(() -> this.client().updateRolePermissions(this.roleUuid(), "/projects/dummy/tagFamilies/" + response.getUuid(), request));
        this.waitForSearchIdleEvent();
        list = (TagFamilyListResponse)ClientHelper.call(() -> this.client().searchTagFamilies(json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The tagFamily should not be found since the requestor has no permission to see it", (long)0L, (long)list.getData().size());
    }
}

