/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.permission;

import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.TagDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.role.HibRole;
import com.gentics.mesh.core.data.tag.HibTag;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.role.RolePermissionRequest;
import com.gentics.mesh.core.rest.tag.TagListResponse;
import com.gentics.mesh.core.rest.tag.TagResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.FULL, startServer=true)
public class TagPermissionSearchTest
extends AbstractMeshTest {
    @Test
    public void testReadPermHandling() throws Exception {
        UserDao userDao;
        String tagname = "testtag42a";
        String tagFamilyUuid = (String)this.tx(() -> this.tagFamily("colors").getUuid());
        TagResponse response = this.createTag("dummy", tagFamilyUuid, tagname);
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            TagDao tagDao = tx.tagDao();
            userDao = tx.userDao();
            HibTag tag = (HibTag)tagDao.findByUuid((HibCoreElement)this.tagFamily("colors"), response.getUuid());
            System.out.println("Tag Uuid:" + response.getUuid());
            for (HibRole role : userDao.getRoles(this.user())) {
                roleDao.revokePermissions(role, (HibBaseElement)tag, new InternalPermission[]{InternalPermission.READ_PERM});
            }
            tx.success();
        }
        this.recreateIndices();
        String json = this.getESText("tagWildcard.es");
        TagListResponse list = (TagListResponse)ClientHelper.call(() -> this.client().searchTags(json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The tag should not be found since the requestor has no permission to see it", (long)0L, (long)list.getData().size());
        try (Tx tx = this.tx();){
            userDao = tx.userDao();
            RoleDao roleDao = tx.roleDao();
            TagDao tagDao = tx.tagDao();
            HibTag tag = (HibTag)tagDao.findByUuid((HibCoreElement)this.tagFamily("colors"), response.getUuid());
            System.out.println("Tag Uuid:" + response.getUuid());
            for (HibRole role : userDao.getRoles(this.user())) {
                roleDao.grantPermissions(role, (HibBaseElement)tag, new InternalPermission[]{InternalPermission.READ_PERM});
            }
            tx.success();
        }
        this.recreateIndices();
        list = (TagListResponse)ClientHelper.call(() -> this.client().searchTags(json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The tag should be found since we added the permission to see it", (long)1L, (long)list.getData().size());
    }

    @Test
    public void testIndexPermUpdate() throws Exception {
        String tagname = "testtag42a";
        String tagFamilyUuid = (String)this.tx(() -> this.tagFamily("colors").getUuid());
        TagResponse response = this.createTag("dummy", tagFamilyUuid, tagname);
        String json = this.getESText("tagWildcard.es");
        this.waitForSearchIdleEvent();
        TagListResponse list = (TagListResponse)ClientHelper.call(() -> this.client().searchTags(json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The tag should be found since the requestor has permission to see it", (long)1L, (long)list.getData().size());
        RolePermissionRequest request = new RolePermissionRequest();
        request.getPermissions().setRead(Boolean.valueOf(false));
        ClientHelper.call(() -> this.client().updateRolePermissions(this.roleUuid(), "/projects/dummy/tagFamilies/" + tagFamilyUuid + "/tags/" + response.getUuid(), request));
        this.waitForSearchIdleEvent();
        list = (TagListResponse)ClientHelper.call(() -> this.client().searchTags(json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The tag should not be found since the requestor has no permission to see it", (long)0L, (long)list.getData().size());
    }
}

