/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.permission;

import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.role.HibRole;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.role.RolePermissionRequest;
import com.gentics.mesh.core.rest.user.UserListResponse;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class UserPermissionSearchTest
extends AbstractMeshTest {
    @Test
    public void testReadPermHandling() throws Exception {
        String username = "testuser42a";
        UserResponse response = this.createUser(username);
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            HibUser user = (HibUser)tx.userDao().findByUuid(response.getUuid());
            System.out.println("User Uuid:" + response.getUuid());
            for (HibRole role : userDao.getRoles(this.user())) {
                roleDao.revokePermissions(role, (HibBaseElement)user, new InternalPermission[]{InternalPermission.READ_PERM});
            }
            tx.success();
        }
        tx = this.tx();
        try {
            this.recreateIndices();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        String json = this.getESText("userWildcard.es");
        UserListResponse list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The user should not be found since the requestor has no permission to see it", (long)0L, (long)list.getData().size());
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            HibUser user = (HibUser)userDao.findByUuid(response.getUuid());
            System.out.println("User Uuid:" + response.getUuid());
            roleDao.grantPermissions(this.role(), (HibBaseElement)user, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            this.recreateIndices();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The user should be found since we added the permission to see it", (long)1L, (long)list.getData().size());
    }

    @Test
    public void testIndexPermUpdate() throws Exception {
        String username = "testuser42a";
        UserResponse response = this.createUser(username);
        this.waitForSearchIdleEvent();
        String json = this.getESText("userWildcard.es");
        UserListResponse list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The user should be found since the requestor has permission to see it", (long)1L, (long)list.getData().size());
        RolePermissionRequest request = new RolePermissionRequest();
        request.getPermissions().setRead(Boolean.valueOf(false));
        ClientHelper.call(() -> this.client().updateRolePermissions(this.roleUuid(), "/users/" + response.getUuid(), request));
        this.waitForSearchIdleEvent();
        list = (UserListResponse)ClientHelper.call(() -> this.client().searchUsers(json, new ParameterProvider[0]));
        Assert.assertEquals((String)"The user should not be found since the requestor has no permission to see it", (long)0L, (long)list.getData().size());
    }
}

