/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.raw;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestHelper;
import io.vertx.core.json.JsonObject;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class GroupRawSearchEndpointTest
extends AbstractMeshTest {
    @Test
    public void testRawSearch() {
        String groupName = "testgroup42a";
        String uuid = this.createGroup(groupName).getUuid();
        String query = MeshTestHelper.getSimpleTermQuery("uuid", uuid);
        this.waitForSearchIdleEvent();
        JsonObject response = new JsonObject(((ObjectNode)ClientHelper.call(() -> this.client().searchGroupsRaw(query))).toString());
        Assert.assertNotNull((Object)response);
        MeshAssertions.assertThat((JsonObject)response).has("responses[0].hits.hits[0]._id", uuid, "The correct element was not found.");
    }
}

