/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.raw;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.etc.config.search.ComplianceMode;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestHelper;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, startServer=true, testSize=TestSize.FULL)
public class NodeRawSearchEndpointTest
extends AbstractMeshTest {
    @Test
    public void testRawSearch() throws Exception {
        try (Tx tx = this.tx();){
            this.recreateIndices();
        }
        String contentFieldValue = "Enemenemuh";
        String contentSchemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        NodeCreateRequest request = new NodeCreateRequest();
        request.setLanguage("en");
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"slugValue"));
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"teaserValue"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Enemenemuh"));
        ProjectResponse projectA = this.createProject("projectA");
        ClientHelper.call(() -> this.client().assignSchemaToProject("projectA", contentSchemaUuid));
        request.setParentNodeUuid(projectA.getRootNode().getUuid());
        NodeResponse nodeA = (NodeResponse)ClientHelper.call(() -> this.client().createNode("projectA", request, new ParameterProvider[0]));
        ProjectResponse projectB = this.createProject("projectB");
        ClientHelper.call(() -> this.client().assignSchemaToProject("projectB", contentSchemaUuid));
        request.setParentNodeUuid(projectB.getRootNode().getUuid());
        NodeResponse nodeB = (NodeResponse)ClientHelper.call(() -> this.client().createNode("projectB", request, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().deleteProject(this.projectUuid()));
        this.waitForSearchIdleEvent();
        JsonObject response = new JsonObject(((ObjectNode)ClientHelper.call(() -> this.client().searchNodesRaw(MeshTestHelper.getSimpleQuery("fields.content", "Enemenemuh"), new ParameterProvider[0]))).toString());
        String path = "responses[0].hits.total";
        if (this.complianceMode() == ComplianceMode.ES_7) {
            path = "responses[0].hits.total.value";
        }
        MeshAssertions.assertThat((JsonObject)response).has(path, "2", "Not exactly two item was found.");
        JsonArray hits = response.getJsonArray("responses").getJsonObject(0).getJsonObject("hits").getJsonArray("hits");
        JsonObject hitOne = hits.getJsonObject(0);
        String uuid1 = hitOne.getString("_id");
        Assert.assertNotNull((Object)hitOne.getJsonObject("_source").getString("branchUuid"));
        JsonObject hitTwo = hits.getJsonObject(1);
        String uuid2 = hitTwo.getString("_id");
        Assert.assertNotNull((String)this.initialBranchUuid(), (Object)hitTwo.getJsonObject("_source").getString("branchUuid"));
        MeshAssertions.assertThat(Arrays.asList(uuid1, uuid2)).containsExactlyInAnyOrder((Object[])new String[]{nodeA.getUuid() + "-en", nodeB.getUuid() + "-en"});
    }

    @Test
    public void testManySchemaSearch() {
        for (int i = 0; i < 45; ++i) {
            SchemaCreateRequest request = new SchemaCreateRequest();
            request.setName("dummy" + i);
            request.addField((FieldSchema)FieldUtil.createHtmlFieldSchema((String)"content"));
            SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", response.getUuid()));
        }
        this.waitForSearchIdleEvent();
        ClientHelper.call(() -> this.client().searchNodesRaw("dummy", MeshTestHelper.getSimpleQuery("fields.content", "the"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L)), new VersioningParametersImpl().draft()}));
    }
}

