/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.raw;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestHelper;
import io.vertx.core.json.JsonObject;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, startServer=true, testSize=TestSize.FULL)
public class ProjectRawSearchEndpointTest
extends AbstractMeshTest {
    @Test
    public void testRawSearch() {
        String projectName = "newproject";
        ProjectResponse project = this.createProject("newproject");
        String query = MeshTestHelper.getSimpleTermQuery("name.raw", "newproject");
        this.waitForSearchIdleEvent();
        JsonObject response = new JsonObject(((ObjectNode)ClientHelper.call(() -> this.client().searchProjectsRaw(query))).toString());
        Assert.assertNotNull((Object)response);
        MeshAssertions.assertThat((JsonObject)response).has("responses[0].hits.hits[0]._id", project.getUuid(), "The correct element was not found.");
    }
}

