/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.raw;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.role.RoleResponse;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestHelper;
import io.vertx.core.json.JsonObject;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class RoleRawSearchEndpointTest
extends AbstractMeshTest {
    @Test
    public void testRawSearch() {
        String roleName = "rolename42a";
        RoleResponse role = this.createRole(roleName, (String)this.db().tx(() -> this.group().getUuid()));
        String query = MeshTestHelper.getSimpleTermQuery("name.raw", roleName);
        this.waitForSearchIdleEvent();
        JsonObject response = new JsonObject(((ObjectNode)ClientHelper.call(() -> this.client().searchRolesRaw(query))).toString());
        MeshAssertions.assertThat((JsonObject)response).has("responses[0].hits.hits[0]._id", role.getUuid(), "The correct element was not found.");
    }
}

