/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.raw;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestHelper;
import io.vertx.core.json.JsonObject;
import org.codehaus.jettison.json.JSONException;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, startServer=true, testSize=TestSize.FULL)
public class SchemaRawSearchEndpointTest
extends AbstractMeshTest {
    @Test
    public void testRawSearch() throws JSONException {
        String name = "newschema";
        SchemaResponse schema = this.createSchema("newschema");
        String query = MeshTestHelper.getSimpleTermQuery("name.raw", "newschema");
        this.waitForSearchIdleEvent();
        JsonObject response = new JsonObject(((ObjectNode)ClientHelper.call(() -> this.client().searchSchemasRaw(query))).toString());
        Assert.assertNotNull((Object)response);
        MeshAssertions.assertThat((JsonObject)response).has("responses[0].hits.hits[0]._id", schema.getUuid(), "The correct element was not found.");
    }
}

