/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.raw.project;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.etc.config.search.ComplianceMode;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestHelper;
import io.vertx.core.json.JsonObject;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, startServer=true, testSize=TestSize.FULL)
public class ProjectNodeRawSearchEndpointTest
extends AbstractMeshTest {
    @Test
    public void testRawSearch() {
        String contentFieldValue = "Enemenemuh";
        String contentSchemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        NodeCreateRequest request = new NodeCreateRequest();
        request.setLanguage("en");
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"slugValue"));
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"teaserValue"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Enemenemuh"));
        ProjectResponse projectA = this.createProject("projectA");
        ClientHelper.call(() -> this.client().assignSchemaToProject("projectA", contentSchemaUuid));
        request.setParentNodeUuid(projectA.getRootNode().getUuid());
        NodeResponse nodeA = (NodeResponse)ClientHelper.call(() -> this.client().createNode("projectA", request, new ParameterProvider[0]));
        ProjectResponse projectB = this.createProject("projectB");
        ClientHelper.call(() -> this.client().assignSchemaToProject("projectB", contentSchemaUuid));
        request.setParentNodeUuid(projectB.getRootNode().getUuid());
        ClientHelper.call(() -> this.client().createNode("projectB", request, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        JsonObject response = new JsonObject(((ObjectNode)ClientHelper.call(() -> this.client().searchNodesRaw("projectA", MeshTestHelper.getSimpleQuery("fields.content", "Enemenemuh"), new ParameterProvider[0]))).toString());
        Assert.assertNotNull((Object)response);
        MeshAssertions.assertThat((JsonObject)response).has("responses[0].hits.hits[0]._id", nodeA.getUuid() + "-en", "The correct element was not found.");
        String path = "responses[0].hits.total";
        if (this.complianceMode() == ComplianceMode.ES_7) {
            path = "responses[0].hits.total.value";
        }
        MeshAssertions.assertThat((JsonObject)response).has(path, "1", "Not exactly one item was found");
    }
}

