/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.raw.project;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.tag.TagFamilyResponse;
import com.gentics.mesh.etc.config.search.ComplianceMode;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestHelper;
import io.vertx.core.json.JsonObject;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, startServer=true, testSize=TestSize.FULL)
public class ProjectTagFamilyRawSearchEndpointTest
extends AbstractMeshTest {
    @Test
    public void testRawSearch() {
        ProjectResponse project = this.createProject("projectB");
        String tagFamilyName = "newtagfamily";
        this.createTagFamily(project.getName(), tagFamilyName);
        TagFamilyResponse tagFamily2 = this.createTagFamily("dummy", tagFamilyName);
        this.waitForSearchIdleEvent();
        String query = MeshTestHelper.getSimpleTermQuery("name.raw", tagFamilyName);
        JsonObject response = new JsonObject(((ObjectNode)ClientHelper.call(() -> this.client().searchTagFamiliesRaw("dummy", query))).toString());
        Assert.assertNotNull((Object)response);
        MeshAssertions.assertThat((JsonObject)response).has("responses[0].hits.hits[0]._id", tagFamily2.getUuid(), "The correct element was not found.");
        String path = "responses[0].hits.total";
        if (this.complianceMode() == ComplianceMode.ES_7) {
            path = "responses[0].hits.total.value";
        }
        MeshAssertions.assertThat((JsonObject)response).has(path, "1", "Not exactly one item was found");
    }
}

