/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.raw.project;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.tag.TagFamilyResponse;
import com.gentics.mesh.core.rest.tag.TagResponse;
import com.gentics.mesh.etc.config.search.ComplianceMode;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestHelper;
import io.vertx.core.json.JsonObject;
import org.codehaus.jettison.json.JSONException;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, startServer=true, testSize=TestSize.FULL)
public class ProjectTagRawSearchEndpointTest
extends AbstractMeshTest {
    @Test
    public void testRawSearch() throws JSONException {
        String tagName = "newtag";
        String tagFamilyName = "newtagfamily";
        ProjectResponse projectA = this.createProject("projectA");
        TagFamilyResponse tagFamilyA = this.createTagFamily(projectA.getName(), tagFamilyName);
        TagResponse tagA = this.createTag("projectA", tagFamilyA.getUuid(), tagName);
        ProjectResponse projectB = this.createProject("projectB");
        TagFamilyResponse tagFamilyB = this.createTagFamily(projectB.getName(), tagFamilyName);
        this.createTag("projectB", tagFamilyB.getUuid(), tagName);
        String query = MeshTestHelper.getSimpleTermQuery("name.raw", tagName);
        this.waitForSearchIdleEvent();
        JsonObject response = new JsonObject(((ObjectNode)ClientHelper.call(() -> this.client().searchTagsRaw("projectA", query))).toString());
        Assert.assertNotNull((Object)response);
        MeshAssertions.assertThat((JsonObject)response).has("responses[0].hits.hits[0]._id", tagA.getUuid(), "The correct element was not found.");
        String path = "responses[0].hits.total";
        if (this.complianceMode() == ComplianceMode.ES_7) {
            path = "responses[0].hits.total.value";
        }
        MeshAssertions.assertThat((JsonObject)response).has(path, "1", "Not exactly one item was found");
    }
}

