/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.resilience;

import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshCoreOptionChanger;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6_TOXIC, startServer=true, testSize=TestSize.FULL, optionChanger=MeshCoreOptionChanger.SMALL_EVENT_BUFFER)
public class ElasticsearchEventBufferTest
extends AbstractMeshTest {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchEventBufferTest.class);

    @Test
    public void testRequestBufferOverflow() throws Exception {
        long createdFolderCount = 10L;
        this.recreateIndices();
        long folderCountBefore = this.getESFolderCount();
        this.elasticsearch().dropTraffic();
        this.expect(MeshEvent.INDEX_SYNC_REQUEST).one();
        int i = 0;
        while ((long)i < createdFolderCount) {
            this.createNode();
            ++i;
        }
        for (i = 0; i < 200; ++i) {
            this.vertx().eventBus().publish(MeshEvent.SEARCH_FLUSH_REQUEST.address, null);
        }
        this.awaitEvents();
        this.elasticsearch().resumeTraffic();
        this.waitForSearchIdleEvent();
        Assert.assertEquals((long)createdFolderCount, (long)(this.getESFolderCount() - folderCountBefore));
    }

    private long getESFolderCount() throws IOException {
        NodeListResponse response = (NodeListResponse)this.client().searchNodes(this.getESText("folders.es"), new ParameterProvider[0]).blockingGet();
        return response.getMetainfo().getTotalCount();
    }
}

