/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.resilience;

import com.gentics.mesh.core.rest.project.ProjectListResponse;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestHelper;
import eu.rekawek.toxiproxy.model.ToxicDirection;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6_TOXIC, startServer=true, testSize=TestSize.FULL)
public class ElasticsearchResilienceTest
extends AbstractMeshTest {
    @Test
    public void testES() throws IOException {
        this.toxics().latency("latency", ToxicDirection.UPSTREAM, 500L);
        String projectName = "newproject";
        ProjectResponse project = this.createProject("newproject");
        String newProjectName = "updatedprojectname";
        this.updateProject(project.getUuid(), newProjectName);
        this.waitForSearchIdleEvent();
        ProjectListResponse response = (ProjectListResponse)this.client().searchProjects(MeshTestHelper.getSimpleTermQuery("name.raw", "newproject"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(2L))}).blockingGet();
        Assert.assertEquals((long)0L, (long)response.getData().size());
    }
}

